# Copilot Instructions for Web165 Laravel Project

## Project Overview
This is a Laravel-based affiliate/referral platform with task-based earnings, mining simulations, spin rewards, and multi-level commissions. Users purchase packages, complete tasks, and earn through referrals with up to 3 levels of commissions and credit scores.

## Architecture
- **MVC Structure**: Controllers in `app/Http/Controllers/`, Models in `app/Models/`, Views in `resources/views/`
- **Admin/User Separation**: Admin controllers handle management, user controllers handle frontend interactions
- **Services**: Business logic in `app/Services/` (e.g., CommissionService for referral payouts)
- **Helpers**: Custom functions in `app/Helper/helpers.php` for file paths, auth guards, and formatting
- **Database**: MySQL with migrations in `database/migrations/`, seeders for initial data
- **Frontend**: Vite + Tailwind CSS + Alpine.js for reactive UI

## Key Components
- **User Management**: Referral system with `ref_id`, upline tracking via `ref_by`
- **Packages**: Define tasks, incomes, spins; purchased via `UserPackage`
- **Earnings Flow**: Tasks → Mining → Commissions → Bonuses → Withdrawals
- **Credit Scores**: Awarded on purchases/tasks, tracked in `User` model
- **Ledgers**: `UserLedger`, `BonusLedger` for transaction history

## Developer Workflows
- **Setup**: `composer install`, `php artisan migrate`, `npm install`, `npm run dev`
- **Local Dev**: Served via XAMPP at `http://localhost/jay/` (configured in `.env`)
- **Testing**: Use Pest (`./vendor/bin/pest`) for unit/feature tests
- **Debugging**: Logs in `storage/logs/`, use `dd()` or Laravel Telescope if installed
- **Build**: `npm run build` for production assets

## Conventions
- **Auth Guards**: `admin()` helper for admin auth, `user()` for users
- **Price Formatting**: `price()` helper uses currency from settings
- **File Uploads**: Store in `public/` subdirs via `main_root()`, `admin_file_root()`, `frontend_file_root()`
- **Transactions**: Wrap multi-step operations in `DB::transaction()` (see CommissionService)
- **Meta Data**: Store extra info as JSON in `meta` columns (e.g., in Commission model)
- **Upline Queries**: Use recursive CTEs or loops for multi-level referrals (see CommissionService::getUplines)
- **Status Tracking**: Use enums like 'active', 'completed', 'approved' consistently

## Integration Points
- **Mail**: SMTP via Gmail for notifications (RegistrationMail)
- **Payments**: External gateways via PaymentMethod model
- **Translations**: Google Translate API for multi-language support
- **Captcha**: mews/captcha for form protection

## Patterns
- **Referral Distribution**: Always check uplines up to 3 levels, distribute commissions/credits proportionally
- **Task Completion**: Update `UserLedger` and `Mining` on task finish
- **Balance Updates**: Use atomic operations to prevent race conditions
- **Validation**: Use Request classes in `app/Http/Requests/` for complex rules

## Examples
- Adding a new earning type: Create model, update CommissionService, add to UserLedger
- New admin feature: Add route in `routes/web.php`, controller in `admin/`, view in `resources/views/admin/`
- User action: Handle in `user/` controller, update balances via ledgers</content>
<parameter name="filePath">c:\xampp\htdocs\Web165\.github\copilot-instructions.md