<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\UserPackage;

class ExpireUserPackages extends Command
{
    protected $signature = 'packages:expire';
    protected $description = 'Expire user packages based on end_date';

    public function handle()
    {
        $expiredCount = UserPackage::where('status', 'active')
            ->whereNotNull('end_date')
            ->where('end_date', '<', now())
            ->update(['status' => 'expired']);

        $this->info("Expired {$expiredCount} user package(s).");

        return Command::SUCCESS;
    }
}
