<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\UserTask;
use Carbon\Carbon;

class ResetDailyTasks extends Command
{
    // Command signature
    protected $signature = 'tasks:reset';

    // Command description
    protected $description = 'Reset daily tasks for all users';

    public function handle()
    {
        // Delete all tasks done today (or mark them pending)
        $today = Carbon::today();

        UserTask::whereDate('created_at', '<', $today)->delete(); // ya update status 'pending'

        $this->info('Daily tasks reset successfully!');
    }
}
