<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\Package;
use App\Models\User;
use App\Models\UserLedger;
use App\Models\UserPackage;
use App\Models\Spin;
use App\Models\UserSpin;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     */
    public function create(Request $request, $id = null)
    {
        if ($id) {
            User::find($id)?->delete();
        }

        $captcha_code = rand(00000, 99999);
        $ref_by = $request->query('ref'); // matches ?ref=XXXX
        return view('app.auth.registration', compact('ref_by', 'captcha_code'));
    }

    /**
     * Handle an incoming registration request.
     */
    public function store(Request $request)
    {
        // Validation
        $validate = Validator::make($request->all(), [
            'phone' => ['required', 'numeric', 'unique:users,phone'],
            'ref_by' => ['required', 'string'],
            'password' => ['required'],
        ], [
            'ref_by.required' => 'Refer code is required',
        ]);

        if ($validate->fails()) {
            $user = User::where('phone', $request->phone)->first();
            if ($user) {
                return back()->with('message', 'Phone number exists');
            }
            return back()->with('message', $validate->errors());
        }

        $getIp = $request->ip();
        if (DB::table('users')->where('ip', $getIp)->exists()) {
           
        }

        // Referral Bonus
        if ($request->ref_by) {
            $refUser = User::where('ref_id', $request->ref_by)->first();
            if ($refUser) {
                $first_level_users = User::where('ref_by', $refUser->ref_id)->count();
                if ($first_level_users <= setting('maximum_refer_friend')) {
                    $refUser->register_refer_bonus += setting('maximum_refer_commission_amount');
                    $refUser->save();
                }
            }
        }

        // Create User
        $user = User::create([
            'name' => 'User' . rand(22, 99),
            'username' => 'uname' . $request->phone,
            'ref_id' => $this->ref_code() . $this->ref_code(),
            'ref_by' => $request->ref_by ?? User::first()->ref_id,
            'email' => 'user' . rand(11111, 99999) . time() . '@gmail.com',
            'password' => Hash::make($request->password),
            'type' => 'user',
            'phone' => $request->phone,
            'register_bonus' => setting('registration_bonus'),
            'balance' => setting('registration_bonus'),
            'phone_code' => '+254',
            'ip' => $getIp,
            'code' => rand(111111, 999999),
            'remember_token' => Str::random(30),
        ]);

        if ($user) {
            // --- Auto assign Free Intern Package ---
            $freePackage = Package::where('type', 'free')->first();
            if ($freePackage) {
                UserPackage::create([
    'user_id' => $user->id,
    'package_id' => $freePackage->id,
    'start_date' => now(),
    'end_date' => now()->addDays($freePackage->validity_days),
    'status' => 'active',
]);


                // Assign spins
                if ($freePackage->spin_count > 0) {
                    $spins = Spin::where('status', 1)->inRandomOrder()->take($freePackage->spin_count)->get();
                    foreach ($spins as $spin) {
                        UserSpin::create([
                            'user_id' => $user->id,
                            'spin_id' => $spin->id,
                            'reward_value' => $spin->reward_value,
                        ]);
                    }
                }
            }

            Auth::login($user);
            return redirect()->route('dashboard')->with('success', 'Registration successful & Free Intern Plan activated!');
        } else {
            return back()->with('message', 'Registration Fail');
        }
    }

    /**
     * Generate referral code.
     */
    public function ref_code()
    {
        $str1 = strtolower(Str::random(2));
        $rand = rand(000, 999);

        return (rand(111, 999) % 2 === 0) ? ($str1 . $rand) : ($rand . $str1);
    }

    /**
     * Refresh Captcha
     */
    public function refreshCaptcha()
    {
        return response()->json(['captcha' => captcha_img()]);
    }
}
