<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;

class AdminCreditController extends Controller
{
    // Display all users with search
    public function index(Request $request)
    {
        $query = User::select('id','username','email','credit_score','balance','status');

        // Search functionality
        if ($request->has('search') && !empty($request->search)) {
            $search = $request->search;
            $query->where(function($q) use ($search) {
                $q->where('username', 'like', "%$search%")
                  ->orWhere('email', 'like', "%$search%");
            });
        }

        $users = $query->get();

        return view('admin.credit.index', compact('users'));
    }

    // Show edit form
    public function edit($id)
    {
        $user = User::findOrFail($id);
        return view('admin.credit.edit', compact('user'));
    }

    // Update credit score
    public function update(Request $request, $id)
    {
        $request->validate([
            'credit_score' => 'required|numeric|min:0',
        ]);

        $user = User::findOrFail($id);
        $user->credit_score = $request->credit_score;
        $user->save();

        return redirect()->route('admin.credit.index')->with('success', 'Credit score updated successfully.');
    }

    // Reset credit score to 0
    public function reset($id)
    {
        $user = User::findOrFail($id);
        $user->credit_score = 0;
        $user->save();

        return redirect()->route('admin.credit.index')->with('success', 'Credit score reset successfully.');
    }
}
