<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Package;

class AdminPackageController extends Controller
{
    // List all packages
    public function index()
    {
        $packages = Package::all();
        return view('admin.packages.index', compact('packages'));
    }

    // Show form to create package
    public function create()
    {
        return view('admin.packages.create');
    }

    // Store new package
    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string|max:255',
            'price' => 'required|numeric',
            'per_task_income' => 'required|numeric',
            'total_income' => 'required|numeric',
            'daily_task_limit' => 'required|integer',
            'validity_days' => 'required|integer',
            'type' => 'required|string|max:50',
            'spins_count' => 'nullable|integer',
            'status' => 'required|boolean',
            'logo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        if ($request->hasFile('logo')) {
            $data['logo'] = $request->file('logo')->store('uploads/packages','public');
        }

        // Default lock status
        $data['is_locked'] = false;

        Package::create($data);

        return redirect()->route('admin.packages.index')->with('success','Package created successfully.');
    }

    // Show edit form
    public function edit(Package $package)
    {
        return view('admin.packages.edit', compact('package'));
    }

    // Update package
    public function update(Request $request, Package $package)
    {
        $data = $request->validate([
            'name' => 'required|string|max:255',
            'price' => 'required|numeric',
            'per_task_income' => 'required|numeric',
            'total_income' => 'required|numeric',
            'daily_task_limit' => 'required|integer',
            'validity_days' => 'required|integer',
            'type' => 'required|string|max:50',
            'spins_count' => 'nullable|integer',
            'status' => 'required|boolean',
            'logo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        if ($request->hasFile('logo')) {
            $data['logo'] = $request->file('logo')->store('uploads/packages','public');
        }

        $package->update($data);

        return redirect()->route('admin.packages.index')->with('success','Package updated successfully.');
    }

    // Delete package
    public function destroy(Package $package)
    {
        $package->delete();
        return redirect()->route('admin.packages.index')->with('success','Package deleted successfully.');
    }

    // Lock/Unlock package
    public function toggleLock(Package $package)
    {
        $package->is_locked = !$package->is_locked;
        $package->save();

        $status = $package->is_locked ? 'locked' : 'unlocked';
        return redirect()->route('admin.packages.index')->with('success', "Package $status successfully.");
    }
}
