<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PaymentMethod;

class PaymentMethodController extends Controller
{
    /**
     * Display a listing of the payment methods.
     */
    public function index()
    {
        $methods = PaymentMethod::orderBy('id', 'desc')->get();
        return view('admin.payment_methods.index', compact('methods'));
    }

    /**
     * Show the form for creating a new payment method.
     */
    public function create()
    {
        return view('admin.payment_methods.form');
    }

    /**
     * Store a newly created payment method in storage.
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'channel'  => 'required|string|max:255',
            'address'  => 'required|string|max:255',
            'receiver' => 'required|string|max:255',
            'minimum'  => 'required|numeric|min:0',
            'maximum'  => 'required|numeric|min:0',
            'status'   => 'required|in:active,inactive',
            'type'     => 'required|string|max:50',
        ]);

        PaymentMethod::create($data);

        return redirect()->route('payment-method.index')
                         ->with('success', 'Payment Method created successfully!');
    }

    /**
     * Show the form for editing the specified payment method.
     */
    public function edit($id)
    {
        $method = PaymentMethod::findOrFail($id);
        return view('admin.payment_methods.form', compact('method'));
    }

    /**
     * Update the specified payment method in storage.
     */
    public function update(Request $request, $id)
    {
        $method = PaymentMethod::findOrFail($id);

        $data = $request->validate([
            'channel'  => 'required|string|max:255',
            'address'  => 'required|string|max:255',
            'receiver' => 'required|string|max:255',
            'minimum'  => 'required|numeric|min:0',
            'maximum'  => 'required|numeric|min:0',
            'status'   => 'required|in:active,inactive',
            'type'     => 'required|string|max:50',
        ]);

        $method->update($data);

        return redirect()->route('payment-method.index')
                         ->with('success', 'Payment Method updated successfully!');
    }

    /**
     * Remove the specified payment method from storage.
     */
    public function destroy($id)
    {
        $method = PaymentMethod::findOrFail($id);
        $method->delete();

        return redirect()->route('payment-method.index')
                         ->with('success', 'Payment Method deleted successfully!');
    }
}
