<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;

class SettingController extends Controller
{
    public $route = 'admin.setting';

    public function index()
    {
        $data = Setting::find(1);
        return view('admin.pages.setting.index', compact('data'));
    }

    public function insert_or_update(Request $request)
    {
        $this->validate($request, [
            'maximum_refer_friend' => 'required|numeric',
            'maximum_refer_commission_amount' => 'required|numeric',
            'registration_bonus' => 'required|numeric',
            'first_level' => 'required|numeric',
            'second_level' => 'required|numeric',
            'third_level' => 'required|numeric',
            'first_level_points' => 'required|numeric',
            'second_level_points' => 'required|numeric',
            'third_level_points' => 'required|numeric',

            // ✅ Task rebate fields
            'task_rebate_first_level' => 'required|numeric',
            'task_rebate_first_level_points' => 'required|numeric',
            'task_rebate_second_level' => 'required|numeric',
            'task_rebate_second_level_points' => 'required|numeric',
            'task_rebate_third_level' => 'required|numeric',
            'task_rebate_third_level_points' => 'required|numeric',
        ]);

        $model = Setting::findOrFail(1);

        // General site settings
        $model->site_name = $request->site_name;
        $model->withdraw_charge = $request->withdraw_charge;
        $model->minimum_withdraw = $request->minimum_withdraw;
        $model->maximum_withdraw = $request->maximum_withdraw;
        $model->currency = $request->currency;
        $model->channel = $request->channel;

        // Referral settings
        $model->maximum_refer_commission_amount = $request->maximum_refer_commission_amount;
        $model->maximum_refer_friend = $request->maximum_refer_friend;
        $model->registration_bonus = $request->registration_bonus;
        $model->first_level = $request->first_level;
        $model->second_level = $request->second_level;
        $model->third_level = $request->third_level;

        // Referral points
        $model->first_level_points = $request->first_level_points;
        $model->second_level_points = $request->second_level_points;
        $model->third_level_points = $request->third_level_points;

        // ✅ Task rebate settings
        $model->task_rebate_first_level = $request->task_rebate_first_level;
        $model->task_rebate_first_level_points = $request->task_rebate_first_level_points;
        $model->task_rebate_second_level = $request->task_rebate_second_level;
        $model->task_rebate_second_level_points = $request->task_rebate_second_level_points;
        $model->task_rebate_third_level = $request->task_rebate_third_level;
        $model->task_rebate_third_level_points = $request->task_rebate_third_level_points;

        // Weekend Break
        $model->is_weekend_break = $request->has('is_weekend_break') ? 1 : 0;

        $model->update();

        return redirect()->route($this->route.'.index')->with('success', 'Settings Updated Successfully.');
    }
}
