<?php

namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use App\Models\Bonus;
use App\Models\BonusLedger;
use App\Models\Checkin;
use App\Models\Mining;
use App\Models\Package;
use App\Models\Purchase;
use App\Models\User;
use App\Models\UserLedger;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class GetBonusController extends Controller
{
    //
    public function index()
    {
        $data = Bonus::where('status', 'active')->first();
        return view('app.main.bonus.index', compact('data'));
    }

    public function gift()
{
    $user = Auth::user();
    
    // Get user's bonus history
    $bonusLedger = BonusLedger::where('user_id', $user->id)
        ->with('bonus') // eager load the related bonus for amount
        ->orderByDesc('created_at')
        ->get();

    return view('app.main.gift.index', compact('bonusLedger'));
}


    public function submitBonusCode(Request $request)
    {$request->validate([
    'bonus_code' => 'required'
]);


        $code = $request->bonus_code;
        $bonus = Bonus::where('status', 'active')->first();
        $user = Auth::user();
        if ($bonus) {
            if ($code == $bonus->code) {
                //Check this bonus use this user.
                $checkBonusUses = BonusLedger::where('bonus_id',$bonus->id )->where('user_id', $user->id)->first();
                if ($checkBonusUses){
                    return response()->json(['status' => false, 'message' => 'You have already used this bonus code.']);
                }
                if ($bonus->counter < $bonus->set_service_counter) {
                    return response()->json(['status' => true, 'amount'=> price($bonus->amount)]);
                } else {
                    return response()->json(['status' => false, 'message' => 'Bonus fulfil']);
                }
            } else {
                return response()->json(['status' => false, 'message' => 'Bonus code invalid.']);
            }
        } else {
            return response()->json(['status' => false, 'message' => 'Bonus not available.']);
        }
    }

    public function submitBonusCodeconfirm(Request $request)
{
    $request->validate([
        'bonus_code' => 'required'
    ]);

    $bonus = Bonus::where('status', 'active')->first();
    $user = Auth::user();

    // Check if the bonus exists and the code matches
    if (!$bonus || $request->bonus_code !== $bonus->code) {
        return response()->json(['status' => false, 'message' => 'Invalid code']);
    }

    // Check if user already used this bonus
    $alreadyUsed = BonusLedger::where('bonus_id', $bonus->id)
        ->where('user_id', $user->id)
        ->exists();

    if ($alreadyUsed) {
        return response()->json(['status' => false, 'message' => 'Already used']);
    }

    // Check if bonus limit reached
    if ($bonus->counter >= $bonus->set_service_counter) {
        return response()->json(['status' => false, 'message' => 'Bonus fulfilled']);
    }

    // Allowed package IDs for this bonus
$allowedPackageIds = [17, 18, 19, 20, 21, 22, 23, 24, 25];

// Get user's packages
$userPackages = DB::table('user_packages')
    ->where('user_id', $user->id)
    ->pluck('package_id')
    ->toArray();

// Check if user has 16 and no allowed package
if (in_array(16, $userPackages) && empty(array_intersect($userPackages, $allowedPackageIds))) {
    return response()->json([
        'status' => false, 
        'message' => 'Intern cannot receive this offer, please upgrade!'
    ]);
}

// Check if user has at least one allowed package
$hasAllowedPackage = array_intersect($userPackages, $allowedPackageIds);

if (empty($hasAllowedPackage)) {
    return response()->json([
        'status' => false, 
        'message' => 'You are not eligible for this offer!'
    ]);
}


    // Everything is fine, redeem the bonus
    DB::transaction(function () use ($bonus, $user, $request) {
        // Add bonus to user balance
        User::where('id', $user->id)->increment('balance', $bonus->amount);

        // Create user ledger
        UserLedger::create([
            'user_id' => $user->id,
            'reason' => 'lucky',
            'perticulation' => 'Lucky draw bonus',
            'amount' => $bonus->amount,
            'credit' => $bonus->amount,
            'status' => 'approved',
            'date' => now(),
        ]);

        // Increment bonus counter
        $bonus->increment('counter');

    


        // Record bonus usage
        BonusLedger::create([
            'user_id' => $user->id,
            'bonus_id' => $bonus->id,
            'bonus_code' => $request->bonus_code,
            'amount' => $bonus->amount, // <-- add this line
        ]);
    });

    return response()->json(['status' => true, 'message' => 'Bonus added successfully']);
}

    public function preview()
    {
        return view('app.main.drow.index_ledger');
    }
public function bonus()
{
    return $this->belongsTo(Bonus::class, 'bonus_id');
}

    public function get_bonus_vip(Request $request)
    {
        $user = Auth::user();
        $refer_users = User::where('ref_by', Auth::user()->ref_id)->get();
        if ($refer_users->count() < 30){
            return response()->json(['status'=> false, 'message'=> 'Need more refer']);
        }

        $bonus_vip = Package::whereNotNull('bonus_vip_id')->first();
        if ($bonus_vip){

            $package = Package::find($bonus_vip->id);
            $user = Auth::user();

            //Purchase Table Create
            $purchase = new Purchase();
            $purchase->user_id = Auth::id();
            $purchase->package_id = $package->id;
            $purchase->amount = $package->price;
            $purchase->hours = $package->hours;
            $purchase->date = date('d-m-Y H:i');
            $purchase->status = 'active';
            $purchase->save();

            //Create Ledger
            $ledger = new UserLedger();
            $ledger->user_id = $user->id;
            $ledger->reason = 'bonus_vip';
            $ledger->perticulation = 'This is bonus vip';
            $ledger->amount = $package->price;
            $ledger->credit = $package->price;
            $ledger->status = 'approved';
            $ledger->date = date('d-m-Y H:i');
            $ledger->save();

            //Create mining info
            $mining = new Mining();
            $mining->user_id = $user->id;
            $mining->package_id = $package->id;
            $mining->purchase_id = $purchase->id;
            $mining->running_start_date = Carbon::now();
            $mining->running_end_date = Carbon::now()->addDays($package->validity);
            $mining->total_time = $package->validity * 24; // total hour
            $mining->continue_date_time = Carbon::now();
            $mining->amount_24_hour = $package->commission_with_avg_amount != 0 ? $package->commission_with_avg_amount / $package->validity : 0;
            $mining->counter_24_hour = $package->validity;
            $mining->running_status = 'start';
            $mining->amount_status = 'false';
            $mining->save();

            User::where('id', $user->id)->update(['bonus_vip'=> '1']);

            return response()->json(['status'=> true, 'message'=> "Congratulations ".Auth::user()->name ?? Auth::user()->username .". VIP purchase successful."]);

        }else{
            return response()->json(['status'=> false, 'message'=> 'Bonus vip not available.']);
        }
    }

    public function checkin(Request $request)
    {
        // check this user already check it
        $check = Checkin::where('user_id', Auth::user()->id)->orderByDesc('id')->first();
        if ($check){
            //check submit today
            $todayCheck = new Carbon($check->date);
            if ($todayCheck->isToday()){
                return response()->json(['status'=> false, 'message'=> 'Already Check in']);
            }
        }

        //Create checkin record
        $model = new Checkin();
        $model->user_id = Auth::id();
        $model->date = Carbon::now();
        $model->amount = setting('checkin_bonus');
        $model->save();

        //Added balance in user account
        User::where('id', Auth::user()->id)->update([
            'balance'=> Auth::user()->balance + setting('checkin_bonus'),
            'commission_balance'=> Auth::user()->commission_balance + setting('checkin_bonus'),
        ]);

        return response()->json(['status'=> true, 'message'=> 'Congratulations']);
    }

    public function checkin_ledger()
    {
        $checkins = Checkin::where('user_id', Auth::id())->orderByDesc('id')->get();
        return view('app.main.checkin-ledger', compact('checkins'));
    }
}
