<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Spin;
use App\Models\UserSpin;
use App\Models\UserPackage;
use Illuminate\Support\Facades\Auth;
use App\Models\User;



class SpinController extends Controller
{
 public function spin()
{
    return $this->belongsTo(Spin::class);
}

    // Show spin page
    public function index()
{
    $user = Auth::user();

    $userPackage = UserPackage::where('user_id', $user->id)
        ->where('status', 'active')
        ->first();

    $hasSpin = false;
    if ($userPackage) {
        $hasSpin = UserSpin::where('user_id', $user->id)
            ->where('package_id', $userPackage->package_id)
            ->exists();
    }

    $spins = Spin::where('status', 1)->get();

    // ✅ spin history (FAST)
    $spinHistory = UserSpin::with('spin')
        ->where('user_id', $user->id)
        ->latest()
        ->limit(20)
        ->get();

    return view('user.spins.index', compact(
        'hasSpin',
        'spins',
        'spinHistory'
    ));
}


private function generateSpinCode()
{
    do {
        $code = str_pad(rand(0, 999999), 6, '0', STR_PAD_LEFT);
    } while (UserSpin::where('spin_code', $code)->exists());

    return $code;
}

    // Play the spin (AJAX)
    public function play(Request $request)
{
    $user = Auth::user();

    // Get all user's active packages
    $userPackages = UserPackage::where('user_id', $user->id)
        ->where('status', 'active')
        ->pluck('package_id')
        ->toArray();

    // Allowed package IDs for spinning
    $allowedPackageIds = [16, 17, 18, 19, 20, 21, 22, 23, 24, 25];

    if (empty($userPackages)) {
        return response()->json([
            'status' => false,
            'message' => '❌ Intern cannot acces lucky draws, please upgrade'
        ]);
    }

    // Block only if user has 16 but NOT 17
    

    // Check if user has at least one allowed package
    $eligiblePackages = array_intersect($userPackages, $allowedPackageIds);
    if (empty($eligiblePackages)) {
        return response()->json([
            'status' => false,
            'message' => '❌ You do not have an eligible package to spin'
        ]);
    }

    // Use the first eligible package for this spin
    $userPackageId = reset($eligiblePackages);

    // Check if user already spun with this package
    $alreadySpun = UserSpin::where('user_id', $user->id)
        ->where('package_id', $userPackageId)
        ->exists();

    if ($alreadySpun) {
        return response()->json([
            'status' => false,
            'message' => '⚠️ You already spun it.'
        ]);
    }

    // Get all active spins
    $spins = Spin::where('status', 1)->get();
    if ($spins->isEmpty()) {
        return response()->json([
            'status' => false,
            'message' => 'ℹ️ The spin rewards are not available.'
        ]);
    }

    // Pick reward based on probability
    $reward = $this->pickRandomSpin($spins);

    // Add reward to user balance if type = amount
    if ($reward->reward_type == 'amount') {
        $user->balance += floatval($reward->reward_value);
        $user->save();
    }

    // Save the spin record
   UserSpin::create([
    'user_id' => $user->id,
    'spin_id' => $reward->id,
    'package_id' => $userPackageId,
    'reward_value' => $reward->reward_value,
    'spin_code' => $this->generateSpinCode(),
]);


    return response()->json([
    'status' => true,
    'message' => "🎉 Congratulations! You won {$reward->reward_value} {$reward->reward_type}",
    'reward' => $reward,
    'spin_code' => $spinCode ?? null
]);

}


    // Helper: Pick a spin based on probability
    private function pickRandomSpin($spins)
    {
        $rand = rand(1, 100);
        $current = 0;

        foreach ($spins as $spin) {
            $current += $spin->probability;
            if ($rand <= $current) {
                return $spin;
            }
        }

        // fallback
        return $spins->first();
    }
}
