<?php

namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use App\Models\Deposit;
use App\Models\User;
use App\Models\UserLedger;
use App\Models\Withdrawal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TeamController extends Controller
{
    // -------------------------------
    // Team Overview
    // -------------------------------
    public function team(Request $request)
    {
        $user = Auth::user();
        $from = $request->from_date;
        $to   = $request->to_date;

        // ---- Levels ----
       


 $first_level_users  = User::where('ref_by', $user->ref_id)->get();



        $second_level_users = User::whereIn('ref_by', $first_level_users->pluck('ref_id'))->get();
        $third_level_users  = User::whereIn('ref_by', $second_level_users->pluck('ref_id'))->get();

        $first_ids = $first_level_users->pluck('id');
        $second_ids = $second_level_users->pluck('id');
        $third_ids = $third_level_users->pluck('id');

        $team_size = $first_level_users->count() + $second_level_users->count() + $third_level_users->count();

        // ---- Helper for Date Filter ----
        $dateFilter = function ($q) use ($from, $to) {
            if ($from && $to) {
                $q->whereBetween('created_at', [$from, $to]);
            }
        };

        // ---- Deposits ----
        $lv1Recharge = Deposit::whereIn('user_id', $first_ids)->where('status', 'approved')->where($dateFilter)->sum('amount');
        $lv2Recharge = Deposit::whereIn('user_id', $second_ids)->where('status', 'approved')->where($dateFilter)->sum('amount');
        $lv3Recharge = Deposit::whereIn('user_id', $third_ids)->where('status', 'approved')->where($dateFilter)->sum('amount');
        $lvTotalDeposit = $lv1Recharge + $lv2Recharge + $lv3Recharge;

        // ---- Withdrawals ----
        $lv1Withdraw = Withdrawal::whereIn('user_id', $first_ids)->where('status', 'approved')->where($dateFilter)->sum('amount');
        $lv2Withdraw = Withdrawal::whereIn('user_id', $second_ids)->where('status', 'approved')->where($dateFilter)->sum('amount');
        $lv3Withdraw = Withdrawal::whereIn('user_id', $third_ids)->where('status', 'approved')->where($dateFilter)->sum('amount');
        $lvTotalWithdraw = $lv1Withdraw + $lv2Withdraw + $lv3Withdraw;

        // ---- Active Members (unique depositors) ----
        $activeMembers1 = Deposit::whereIn('user_id', $first_ids)->where('status', 'approved')->where($dateFilter)->distinct('user_id')->count('user_id');
        $activeMembers2 = Deposit::whereIn('user_id', $second_ids)->where('status', 'approved')->where($dateFilter)->distinct('user_id')->count('user_id');
        $activeMembers3 = Deposit::whereIn('user_id', $third_ids)->where('status', 'approved')->where($dateFilter)->distinct('user_id')->count('user_id');

        return view('app.main.team.index', compact(
            'first_level_users',
            'second_level_users',
            'third_level_users',
            'team_size',
            'lvTotalDeposit',
            'lvTotalWithdraw',
            'lv1Recharge',
            'lv2Recharge',
            'lv3Recharge',
            'lv1Withdraw',
            'lv2Withdraw',
            'lv3Withdraw',
            'activeMembers1',
            'activeMembers2',
            'activeMembers3',
            'from',
            'to'
        ));
    }

    // -------------------------------
    // User Details per Level
    // -------------------------------
    public function user_details(Request $request)
    {
        $user = Auth::user();
        $step = $request->get('step'); // 1,2,3 or "all"

        // ---- Levels ----
        $first_level_users  = User::where('ref_by', $user->ref_id)->get();
        $second_level_users = User::whereIn('ref_by', $first_level_users->pluck('ref_id'))->get();
        $third_level_users  = User::whereIn('ref_by', $second_level_users->pluck('ref_id'))->get();

        // ---- Filtering ----
        if ($step == '1') {
            $users = $first_level_users;
        } elseif ($step == '2') {
            $users = $second_level_users;
        } elseif ($step == '3') {
            $users = $third_level_users;
        } elseif ($step == 'all') {
            $users = $first_level_users->merge($second_level_users)->merge($third_level_users);
        } else {
            return back()->with('error', 'Invalid step selected');
        }

        return view('app.main.team.list', compact('users', 'step'));
    }





    // -------------------------------
    // Commission Receive
    // -------------------------------
    public function get_recharge_amount($step)
    {
        $user = Auth::user();
        $updateData = [];

        if ($step == 'com1' && $user->recharge_1_com > 0) {
            $updateData = [
                'balance'          => $user->balance + $user->recharge_1_com,
                'commission_balance'=> $user->commission_balance + $user->recharge_1_com,
                'received_balance1' => $user->received_balance1 + $user->recharge_1_com,
                'recharge_1_com'   => 0,
            ];
        }
        if ($step == 'com2' && $user->recharge_2_com > 0) {
            $updateData = [
                'balance'          => $user->balance + $user->recharge_2_com,
                'commission_balance'=> $user->commission_balance + $user->recharge_2_com,
                'received_balance2' => $user->received_balance2 + $user->recharge_2_com,
                'recharge_2_com'   => 0,
            ];
        }
        if ($step == 'com3' && $user->recharge_3_com > 0) {
            $updateData = [
                'balance'          => $user->balance + $user->recharge_3_com,
                'commission_balance'=> $user->commission_balance + $user->recharge_3_com,
                'received_balance3' => $user->received_balance3 + $user->recharge_3_com,
                'recharge_3_com'   => 0,
            ];
        }

        if (!empty($updateData)) {
            $user->update($updateData);
            return redirect()->route('team')->with('message', 'Commission Received');
        }

        return back()->with('error', 'No commission available');
    }

    // -------------------------------
    // Income Page
    // -------------------------------
    public function income()
    {
        return view('app.main.income');
    }

    // -------------------------------
    // Level Details + Commission Info
    // -------------------------------
    public function lvl_details($ids, $lvl)
    {
        $ids = decrypt($ids);
        $users = User::whereIn('id', $ids)->get();

        // ---- Commission ----
        $sponsorCom  = UserLedger::where('user_id', Auth::id())->where('reason', 'sponsor_bonus')->sum('amount');
        $referralCom = UserLedger::where('user_id', Auth::id())->where('reason', 'refer_bonus')->sum('amount');

        // ---- Payments ----
        $total_payment = Deposit::whereIn('user_id', $ids)->sum('amount');

        return view('app.main.team.list', compact('users', 'lvl', 'total_payment', 'sponsorCom', 'referralCom'));
    }
}
