<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UserCreditScoreController extends Controller
{
    public function index()
    {
        $user = Auth::user();

        // Current credit score
        $creditScore = $user->credit_score ?? 60;

        // Optional: if you have a separate CreditRecord table for history
        $creditRecords = $user->creditRecords ?? []; // if relationship exists

        return view('user.credit_score', compact('creditScore', 'creditRecords'));
    }
}
