<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Deposit extends Model
{
    use HasFactory;

    // ✅ Correct fillable according to deposits table
    protected $fillable = [
        'user_id',
        'method_name',
        'address',
        'transaction_id',
        'order_id',
        'amount',
        'final_amount',
        'date',
        'status',
    ];

    // ✅ Relationship with User
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
