<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Task extends Model
{
    protected $fillable = [
        'title', 'description', 'logo', 'fake_downloads', 'reward_amount', 'package_id', 'status'
    ];

    public function package()
    {
        return $this->belongsTo(Package::class);
    }

    public function users()
    {
        return $this->belongsToMany(User::class, 'user_tasks')
                    ->withPivot('status','earned')
                    ->withTimestamps();
    }
}
