<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserPackage extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'package_id',
        'start_date',
        'end_date',
        'status'
    ];

    // ✅ THIS IS REQUIRED
    protected $casts = [
        'start_date' => 'datetime',
        'end_date'   => 'datetime',
    ];

    public function package()
    {
        return $this->belongsTo(\App\Models\Package::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
