<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WealthPlan extends Model
{
    use HasFactory;

    protected $table = 'wealth_plans';

    // Include all columns you want to mass-assign
    protected $fillable = [
        'name',
        'min_amount',
        'max_amount',
        'description',
        'days',
        'profit_percent',
        'status'
    ];

    // Relations
    public function investments()
    {
        return $this->hasMany(UserWealth::class, 'wealth_plan_id');
    }
}
