<?php

namespace App\Observers;

use App\Models\UserPackage;
use App\Models\UserSpin;
use App\Models\User;

class UserPackageObserver
{
    public function created(UserPackage $userPackage)
    {
        // Only active packages
        if ($userPackage->status !== 'active') return;

        // Only paid packages 17–25
        if ($userPackage->package_id < 17 || $userPackage->package_id > 25) return;

        $joinedUser = User::find($userPackage->user_id);
        if (!$joinedUser || !$joinedUser->ref_by) return;

        $referrerId = $joinedUser->ref_by;

        // Prevent duplicate referral spins
        $alreadyGiven = UserSpin::where('user_id', $referrerId)
            ->where('package_id', $userPackage->package_id)
            ->where('is_referral', 1)
            ->exists();

        if ($alreadyGiven) return;

        // Create referral spin (unplayed, spin_id NULL)
        UserSpin::create([
            'user_id'     => $referrerId,
            'spin_id'     => null,
            'package_id'  => $userPackage->package_id,
            'reward_value'=> null,
            'spin_code'   => null,
            'is_referral' => 1,
        ]);
    }
}
