<?php

namespace App\Providers;

use App\Models\Notice;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\DB; // ✅ Import DB

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        // Nothing needed here for timezone
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Set DB session timezone to Kenya time
        DB::statement("SET time_zone = '+03:00'");

        // Share latest 3 notices with all views
        View::composer('*', function ($view) {
            $view->with(
                'datas',
                Notice::latest()->take(3)->get()
            );
        });
    }
}
