@extends('admin.partials.master')
@section('admin_content')
<div class="container py-4">
    <h3>Edit Credit Score for: {{ $user->username }}</h3>

    <form action="{{ route('admin.credit.update', $user->id) }}" method="POST" class="mt-3">
        @csrf
        @method('PUT')

        <div class="mb-3">
            <label for="credit_score" class="form-label">Credit Score</label>
            <input type="number" name="credit_score" id="credit_score" class="form-control" value="{{ old('credit_score', $user->credit_score) }}" min="0" required>
        </div>

        <button type="submit" class="btn btn-success">Update</button>
        <a href="{{ route('admin.credit.index') }}" class="btn btn-secondary">Cancel</a>
    </form>
</div>
@endsection
