@extends('admin.partials.master')
@section('admin_content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header"><h4>Add New Package</h4></div>
            <div class="card-body">
                <form action="{{ route('admin.packages.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Name</label>
                            <input type="text" name="name" class="form-control" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Price</label>
                            <input type="number" step="0.01" name="price" class="form-control" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Per Task Income</label>
                            <input type="number" step="0.01" name="per_task_income" class="form-control" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Total Income</label>
                            <input type="number" step="0.01" name="total_income" class="form-control" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Daily Task Limit</label>
                            <input type="number" name="daily_task_limit" class="form-control" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Validity (Days)</label>
                            <input type="number" name="validity_days" class="form-control" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Type</label>
                            <select name="type" class="form-control">
                                <option value="free">Free</option>
                                <option value="paid">Paid</option>
                            </select>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Spins Count</label>
                            <input type="number" name="spins_count" class="form-control" value="0">
                        </div>
                        <div class="form-group col-md-6">
                            <label>Package Logo</label>
                            <input type="file" name="logo" class="form-control-file">
                        </div>
                        <div class="form-group col-md-6">
                            <label>Status</label>
                            <select name="status" class="form-control">
                                <option value="1">Active</option>
                                <option value="0">Inactive</option>
                            </select>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary">Create Package</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
