@extends('admin.partials.master')
@section('admin_content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4 class="card-title">All Packages</h4>
                <a href="{{ route('admin.packages.create') }}" class="btn btn-primary">Add New Package</a>
            </div>
            <div class="card-body table-responsive">
                <table class="table table-striped table-bordered table-hover">
                    <thead class="thead-dark">
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Price</th>
                            <th>Per Task Income</th>
                            <th>Total Income</th>
                            <th>Daily Task Limit</th>
                            <th>Validity (Days)</th>
                            <th>Type</th>
                            <th>Spins Count</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($packages as $package)
                        <tr>
                            <td>{{ $package->id }}</td>
                            <td>{{ $package->name }}</td>
                            <td>{{ $package->price }}</td>
                            <td>{{ $package->per_task_income }}</td>
                            <td>{{ $package->total_income }}</td>
                            <td>{{ $package->daily_task_limit }}</td>
                            <td>{{ $package->validity_days }}</td>
                            <td>{{ ucfirst($package->type) }}</td>
                            <td>{{ $package->spins_count }}</td>
                            <td>
                                @if($package->status)
                                    <span class="badge badge-success">Active</span>
                                @else
                                    <span class="badge badge-danger">Inactive</span>
                                @endif
                                @if($package->is_locked)
                                    <span class="badge badge-warning ml-1">Locked</span>
                                @endif
                            </td>
                            <td>
                                <!-- Edit -->
                                <a href="{{ route('admin.packages.edit', $package->id) }}" class="btn btn-sm btn-info mb-1">Edit</a>
                                
                                <!-- Delete -->
                                <form action="{{ route('admin.packages.destroy', $package->id) }}" method="POST" style="display:inline-block;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger mb-1" onclick="return confirm('Are you sure?')">Delete</button>
                                </form>
                                
                                <!-- Lock/Unlock -->
                                <form action="{{ route('admin.packages.toggleLock', $package->id) }}" method="POST" style="display:inline-block;">
                                    @csrf
                                    <button type="submit" class="btn btn-sm @if($package->is_locked) btn-success @else btn-warning @endif mb-1">
                                        @if($package->is_locked) Unlock @else Lock @endif
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
