@extends('admin.partials.master')
@section('admin_content')
    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h4 class="card-title">
                            <div class="d-flex justify-content-between">
                                <div>Payment Method Lists</div>
                                <div>
                                    <a href="{{route('admin.method.create')}}" class="btn btn-primary btn-sm">
                                        <i class="bx bx-plus"></i> Add New Item
                                    </a>
                                </div>
                            </div>
                        </h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table table-striped dataex-html5-selectors">
                                    <thead>
                                    <tr>
                                        <th>S.N</th>
                                        <th>Photo</th>
                                        <th>Type</th>
                                        <th>Address</th>
                                        <th>Bank Info</th>
                                        <th>Limits</th>
                                        <th>Charge</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($methods as $key => $row)
                                        <tr>
                                            <td>{{$key + 1}}</td>

                                            {{-- ✅ Photo --}}
                                            <td>
                                                <img width="40" src="{{asset(view_image($row->photo))}}" alt="Method Photo">
                                            </td>

                                            {{-- ✅ Type --}}
                                            <td>
                                                <span class="badge badge-info text-uppercase">
                                                    {{$row->type ?? '--'}}
                                                </span>
                                            </td>

                                            {{-- ✅ Address --}}
                                            <td>
                                                {{$row->address ?? '--'}}
                                            </td>

                                            {{-- ✅ Bank Details --}}
                                            <td>
                                                <small>
                                                    <strong>Bank:</strong> {{$row->bank_name ?? '--'}} <br>
                                                    <strong>Holder:</strong> {{$row->account_holder ?? '--'}}
                                                </small>
                                            </td>

                                            {{-- ✅ Limits --}}
                                            <td>
                                                <small>
                                                    Min: {{$row->min_amount ?? 0}} <br>
                                                    Max: {{$row->max_amount ?? 0}}
                                                </small>
                                            </td>

                                            {{-- ✅ Charge --}}
                                            <td>
                                                <small>
                                                    Type: {{$row->charge_type ?? '--'}} <br>
                                                    Value: {{$row->charge_value ?? 0}}
                                                </small>
                                            </td>

                                            {{-- ✅ Status --}}
                                            <td>
                                                <span class="badge 
                                                    @if($row->status == 'active' || $row->status == 1) badge-success 
                                                    @else badge-danger @endif">
                                                    {{$row->status == 'active' || $row->status == 1 ? 'Active' : 'Inactive'}}
                                                </span>
                                            </td>

                                            {{-- ✅ Action --}}
                                            <td>
                                                <a href="{{route('admin.method.create', $row->id)}}"
                                                   class="btn btn-warning btn-sm" data-toggle="tooltip" title='Edit'>
                                                    <i class="bx bx-pencil"></i>
                                                </a>

                                                <form method="POST" action="{{route('admin.method.delete', $row->id)}}"
                                                      class="d-inline">@csrf
                                                    {{method_field('DELETE')}}
                                                    <button type="submit" class="btn btn-danger btn-sm"
                                                            data-toggle="tooltip" title='Delete'>
                                                        <i class="bx bx-trash"></i>
                                                    </button>
                                                    @include('admin.partials.delete-confirmation')
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
