@extends('admin.partials.master')
@section('admin_content')
    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-12">
          <form action="{{ route('payment-method.insert_or_update') }}" method="POST">
@csrf
                    <input type="hidden" name="id" value="{{$data ? $data->id : ''}}">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">
                                <div class="d-flex justify-content-between">
                                    <div>{{$data ? 'Update' : 'Create New'}} Payment Method</div>
                                    <div>
                                        <a href="{{route('admin.method.index')}}" class="btn btn-primary btn-sm">
                                            <i class="bx bx-left-arrow"></i> Method List
                                        </a>
                                    </div>
                                </div>
                            </h4>
                        </div>
                        <div class="card-content">
                            <div class="card-body">
                                <div class="row">

                                    {{-- ✅ Type --}}
                                    <div class="col-sm-12 mt-2">
                                        <label for="type">Payment Method Type</label>
                                        <select name="type" id="type" class="form-control" required>
                                            <option value="">-- Select Type --</option>
                                            <option value="wallet" {{isset($data) && $data->type == 'wallet' ? 'selected' : ''}}>Wallet</option>
                                            <option value="usdt" {{isset($data) && $data->type == 'usdt' ? 'selected' : ''}}>USDT</option>
                                            <option value="bank" {{isset($data) && $data->type == 'bank' ? 'selected' : ''}}>Bank</option>
                                            <option value="crypto" {{isset($data) && $data->type == 'crypto' ? 'selected' : ''}}>Crypto</option>
                                        </select>
                                    </div>

                                    {{-- ✅ Address --}}
                                    <div class="col-sm-12 mt-2">
                                        <label for="address">Address</label>
                                        <textarea class="form-control"
                                                  name="address"
                                                  id="address"
                                                  rows="2"
                                                  placeholder="Enter Address">{{$data->address ?? old('address')}}</textarea>
                                    </div>

                                    {{-- ✅ Bank Name --}}
                                    <div class="col-sm-6 mt-2">
                                        <label for="bank_name">Bank Name</label>
                                        <input type="text" class="form-control"
                                               name="bank_name" id="bank_name"
                                               placeholder="Bank Name" value="{{$data->bank_name ?? old('bank_name')}}">
                                    </div>

                                    {{-- ✅ Account Holder --}}
                                    <div class="col-sm-6 mt-2">
                                        <label for="account_holder">Account Holder</label>
                                        <input type="text" class="form-control"
                                               name="account_holder" id="account_holder"
                                               placeholder="Account Holder" value="{{$data->account_holder ?? old('account_holder')}}">
                                    </div>

                                    {{-- ✅ Min / Max Amount --}}
                                    <div class="col-sm-6 mt-2">
                                        <label for="min_amount">Min Amount</label>
                                        <input type="number" step="0.01" class="form-control"
                                               name="min_amount" id="min_amount"
                                               placeholder="Minimum Amount" value="{{$data->min_amount ?? old('min_amount')}}">
                                    </div>

                                    <div class="col-sm-6 mt-2">
                                        <label for="max_amount">Max Amount</label>
                                        <input type="number" step="0.01" class="form-control"
                                               name="max_amount" id="max_amount"
                                               placeholder="Maximum Amount" value="{{$data->max_amount ?? old('max_amount')}}">
                                    </div>

                                    {{-- ✅ Charge Type --}}
                                    <div class="col-sm-6 mt-2">
                                        <label for="charge_type">Charge Type</label>
                                        <select name="charge_type" id="charge_type" class="form-control">
                                            <option value="">-- Select --</option>
                                            <option value="fixed" {{isset($data) && $data->charge_type == 'fixed' ? 'selected' : ''}}>Fixed</option>
                                            <option value="percent" {{isset($data) && $data->charge_type == 'percent' ? 'selected' : ''}}>Percent</option>
                                        </select>
                                    </div>

                                    {{-- ✅ Charge Value --}}
                                    <div class="col-sm-6 mt-2">
                                        <label for="charge_value">Charge Value</label>
                                        <input type="number" step="0.01" class="form-control"
                                               name="charge_value" id="charge_value"
                                               placeholder="Charge Value" value="{{$data->charge_value ?? old('charge_value')}}">
                                    </div>

                                    {{-- ✅ Upload Photo --}}
                                    <div class="col-sm-12 mt-3">
                                        <div class="row">
                                            <div class="col-12 col-sm-6">
                                                <fieldset class="form-group">
                                                    <label for="basicInputFile">Upload Photo <small>(200x200px)</small></label>
                                                    <div class="custom-file">
                                                        <input type="file" name="photo"
                                                               class="custom-file-input" id="inputGroupFile01"
                                                               onchange="showPreview(event)">
                                                        <label class="custom-file-label" for="inputGroupFile01">Choose file</label>
                                                    </div>
                                                </fieldset>
                                            </div>
                                            <div class="col-12 col-sm-6">
                                                <div class="image_preview">
                                                    <img src="{{$data ? asset(view_image($data->photo)) : asset(not_found_img())}}"
                                                         id="file-ip-1-preview" class="rounded"
                                                         style="width: 100px;height: 100px">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    {{-- ✅ Status --}}
                                    <div class="col-sm-12 mt-2">
                                        <label for="status">Status</label>
                                        <select name="status" id="status" class="form-control">
                                            <option value="1" {{isset($data) && $data->status == 1 ? 'selected' : ''}}>Active</option>
                                            <option value="0" {{isset($data) && $data->status == 0 ? 'selected' : ''}}>Inactive</option>
                                        </select>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Submit -->
                    <div class="card">
                        <div class="card-header">
                            <h6 class="card-title">
                                <div class="d-flex justify-content-between">
                                    <div style="margin-top: .7rem">Submit Your Payment Method Information</div>
                                    <div>
                                        <button type="submit" class="btn btn-success">
                                            <i class="bx bx-plus"></i> {{$data ? 'Update' : 'Submit'}}
                                        </button>
                                    </div>
                                </div>
                            </h6>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>

    <script>
        function showPreview(event){
            if(event.target.files.length > 0){
                var src = URL.createObjectURL(event.target.files[0]);
                var preview = document.getElementById("file-ip-1-preview");
                preview.src = src;
                preview.style.display = "block";
            }
        }
    </script>
@endsection
