@extends('admin.partials.master')
@section('admin_content')
<style>
    label {
        text-transform: unset;
    }
</style>
<section id="dashboard-ecommerce">
    <div class="row">
        <div class="col-12">
            <form action="{{ route('admin.setting.insert') }}" method="POST" enctype="multipart/form-data">@csrf
                <input type="hidden" name="id" value="{{ $data ? $data->id : '' }}">
                
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <div class="d-flex justify-content-between">
                                <div>{{ $data ? 'Update' : 'Create New' }} Settings</div>
                            </div>
                        </h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-12 mt-2">
                                    <div class="row">

                                        <!-- Withdraw Charge -->
                                        <div class="col-sm-6">
                                            <label for="withdraw_charge">Withdraw charge%</label>
                                            <input type="number" class="form-control"
                                                   name="withdraw_charge" id="withdraw_charge"
                                                   value="{{ $data->withdraw_charge ?? old('withdraw_charge') }}">
                                        </div>

                                        <!-- Minimum Withdraw -->
                                        <div class="col-sm-6">
                                            <label for="minimum_withdraw">Minimum Withdraw</label>
                                            <input type="number" class="form-control"
                                                   name="minimum_withdraw" id="minimum_withdraw"
                                                   value="{{ $data->minimum_withdraw ?? old('minimum_withdraw') }}">
                                        </div>

                                        <!-- Maximum Withdraw -->
                                        <div class="col-sm-6">
                                            <label for="maximum_withdraw">Maximum Withdraw</label>
                                            <input type="number" class="form-control"
                                                   name="maximum_withdraw" id="maximum_withdraw"
                                                   value="{{ $data->maximum_withdraw ?? old('maximum_withdraw') }}">
                                        </div>

                                        <!-- Site Name -->
                                        <div class="col-sm-6">
                                            <label for="site_name">Site Name</label>
                                            <input type="text" class="form-control"
                                                   name="site_name" id="site_name"
                                                   value="{{ $data->site_name ?? '' }}" required>
                                        </div>

                                        <!-- Currency -->
                                        <div class="col-sm-6">
                                            <label for="currency">Currency</label>
                                            <input type="text" class="form-control"
                                                   name="currency" id="currency"
                                                   value="{{ $data->currency ?? '' }}" required>
                                        </div>

                                        <!-- Channel -->
                                        <div class="col-sm-6">
                                            <label for="channel">Channel</label>
                                            <input type="text" class="form-control"
                                                   name="channel" id="channel"
                                                   value="{{ $data->channel ?? '' }}" required>
                                        </div>

                                        <!-- Maximum Refer Friend -->
                                        <div class="col-sm-6">
                                            <label for="maximum_refer_friend">Maximum Refer Friend</label>
                                            <input type="number" class="form-control"
                                                   name="maximum_refer_friend" id="maximum_refer_friend"
                                                   value="{{ $data->maximum_refer_friend ?? '' }}" required>
                                        </div>

                                        <!-- Maximum Refer Commission Amount -->
                                        <div class="col-sm-6">
                                            <label for="maximum_refer_commission_amount">Maximum Refer Commission Amount</label>
                                            <input type="number" class="form-control"
                                                   name="maximum_refer_commission_amount" id="maximum_refer_commission_amount"
                                                   value="{{ $data->maximum_refer_commission_amount ?? '' }}" required>
                                        </div>

                                        <!-- Registration Bonus -->
                                        <div class="col-sm-6">
                                            <label for="registration_bonus">Registration Bonus</label>
                                            <input type="number" class="form-control"
                                                   name="registration_bonus" id="registration_bonus"
                                                   value="{{ $data->registration_bonus ?? '' }}" required>
                                        </div>

                                        <!-- Referral Levels (%) -->
                                        <div class="col-sm-4 mt-3">
                                            <label for="first_level">First Level Refer (%)</label>
                                            <input type="number" class="form-control"
                                                   name="first_level" id="first_level"
                                                   value="{{ $data->first_level ?? '' }}" required>
                                        </div>
                                        <div class="col-sm-4 mt-3">
                                            <label for="second_level">Second Level Refer (%)</label>
                                            <input type="number" class="form-control"
                                                   name="second_level" id="second_level"
                                                   value="{{ $data->second_level ?? '' }}" required>
                                        </div>
                                        <div class="col-sm-4 mt-3">
                                            <label for="third_level">Third Level Refer (%)</label>
                                            <input type="number" class="form-control"
                                                   name="third_level" id="third_level"
                                                   value="{{ $data->third_level ?? '' }}" required>
                                        </div>

                                        <!-- Referral Points -->
                                        <div class="col-sm-4 mt-3">
                                            <label for="first_level_points">First Level Points</label>
                                            <input type="number" class="form-control"
                                                   name="first_level_points" id="first_level_points"
                                                   value="{{ $data->first_level_points ?? 5 }}" required>
                                        </div>
                                        <div class="col-sm-4 mt-3">
                                            <label for="second_level_points">Second Level Points</label>
                                            <input type="number" class="form-control"
                                                   name="second_level_points" id="second_level_points"
                                                   value="{{ $data->second_level_points ?? 3 }}" required>
                                        </div>
                                        <div class="col-sm-4 mt-3">
                                            <label for="third_level_points">Third Level Points</label>
                                            <input type="number" class="form-control"
                                                   name="third_level_points" id="third_level_points"
                                                   value="{{ $data->third_level_points ?? 1 }}" required>
                                        </div>

                                        <!-- ============================= -->
                                        <!-- Task Rebate Commission -->
                                        <!-- ============================= -->
                                        <div class="col-sm-4 mt-3">
                                            <label for="task_rebate_first_level">Task Rebate First Level (%)</label>
                                            <input type="number" class="form-control"
                                                   name="task_rebate_first_level" id="task_rebate_first_level"
                                                   value="{{ $data->task_rebate_first_level ?? 5 }}" required>
                                        </div>
                                        <div class="col-sm-4 mt-3">
                                            <label for="task_rebate_second_level">Task Rebate Second Level (%)</label>
                                            <input type="number" class="form-control"
                                                   name="task_rebate_second_level" id="task_rebate_second_level"
                                                   value="{{ $data->task_rebate_second_level ?? 3 }}" required>
                                        </div>
                                        <div class="col-sm-4 mt-3">
                                            <label for="task_rebate_third_level">Task Rebate Third Level (%)</label>
                                            <input type="number" class="form-control"
                                                   name="task_rebate_third_level" id="task_rebate_third_level"
                                                   value="{{ $data->task_rebate_third_level ?? 1 }}" required>
                                        </div>

                                        <!-- Task Rebate Points -->
                                        <div class="col-sm-4 mt-3">
                                            <label for="task_rebate_first_level_points">Task Rebate First Level Points</label>
                                            <input type="number" class="form-control"
                                                   name="task_rebate_first_level_points" id="task_rebate_first_level_points"
                                                   value="{{ $data->task_rebate_first_level_points ?? 2 }}" required>
                                        </div>
                                        <div class="col-sm-4 mt-3">
                                            <label for="task_rebate_second_level_points">Task Rebate Second Level Points</label>
                                            <input type="number" class="form-control"
                                                   name="task_rebate_second_level_points" id="task_rebate_second_level_points"
                                                   value="{{ $data->task_rebate_second_level_points ?? 1 }}" required>
                                        </div>
                                        <div class="col-sm-4 mt-3">
                                            <label for="task_rebate_third_level_points">Task Rebate Third Level Points</label>
                                            <input type="number" class="form-control"
                                                   name="task_rebate_third_level_points" id="task_rebate_third_level_points"
                                                   value="{{ $data->task_rebate_third_level_points ?? 1 }}" required>
                                        </div>

                                        <!-- Weekend Break -->
                                        <div class="col-sm-6 mt-3">
                                            <label for="is_weekend_break">Weekend Break</label>
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="is_weekend_break" name="is_weekend_break"
                                                       {{ $data && $data->is_weekend_break ? 'checked' : '' }}>
                                                <label class="form-check-label" for="is_weekend_break">
                                                    Enable Weekend Break (If ON, users cannot access tasks on weekends)
                                                </label>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Form Submit Button -->
                <div class="card mt-3">
                    <div class="card-header">
                        <h6 class="card-title">
                            <div class="d-flex justify-content-between">
                                <div style="margin-top: .7rem !important">
                                    Submit Your Setting Information
                                </div>
                                <div>
                                    <div class="form-group mb-0">
                                        <button type="submit" class="btn btn-success">
                                            <i class="bx bx-plus"></i> {{ $data ? 'Update' : 'Submit' }}
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </h6>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>
@endsection
