@extends('admin.partials.master')

@section('admin_content')
<style>
div#DataTables_Table_0_wrapper .btn {
    padding: 0 1.5rem;
    margin: 9px !important;
}
.table img {
    max-width: 120px;
    border: 1px solid #ddd;
    border-radius: 6px;
}
.badge {
    font-size: 0.7rem;
    padding: 0.3rem 0.5rem;
}
</style>

<section id="dashboard-ecommerce">
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-header pb-0">
                    <h4 class="card-title">
                        <div class="d-flex justify-content-between">
                            <div>Payment Methods List</div>
                            <a href="{{ route('payment-method.create') }}" class="btn btn-success">Add New Payment Method</a>
                        </div>
                    </h4>
                </div>
                <div class="card-content">
                    <div class="card-body card-dashboard">
                        <div class="table-responsive">
                            <table class="table table-striped dataex-html5-selectors">
                                <thead>
                                    <tr>
                                        <th>S.N</th>
                                        <th>Channel</th>
                                        <th>Address</th>
                                        <th>Receiver</th>
                                        <th>Min</th>
                                        <th>Max</th>
                                        <th>Status</th>
                                        <th>Type</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($methods as $key => $method)
                                        <tr>
                                            <td>{{ $key + 1 }}</td>
                                            <td>{{ $method->channel }}</td>
                                            <td>{{ $method->address }}</td>
                                            <td>{{ $method->receiver }}</td>
                                            <td>{{ $method->minimum }}</td>
                                            <td>{{ $method->maximum }}</td>
                                            <td>
                                                <span class="badge @if($method->status == 'active') badge-success @else badge-danger @endif">
                                                    {{ ucfirst($method->status) }}
                                                </span>
                                            </td>
                                            <td>{{ $method->type }}</td>
                                            <td>
                                                <a href="{{ route('payment-method.edit', $method->id) }}" class="btn btn-primary btn-sm">Edit</a>
                                                <form action="{{ route('payment-method.destroy', $method->id) }}" method="POST" style="display:inline-block;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" onclick="return confirm('Are you sure?')" class="btn btn-danger btn-sm">
                                                        Delete
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="9" class="text-center">No Payment Methods found.</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div> <!-- /.table-responsive -->
                    </div> <!-- /.card-body -->
                </div> <!-- /.card-content -->
            </div> <!-- /.card -->
        </div>
    </div>
</section>
@endsection
