@extends('admin.partials.master')
@section('admin_content')
<div class="container py-8">
    <h2 class="text-2xl font-bold mb-6">Add New Spin</h2>

    <form action="{{ route('admin.spins.store') }}" method="POST">
        @csrf
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="block text-gray-700">Package</label>
                <select name="package_id" class="form-control">
                    <option value="">All Packages</option>
                    @foreach($packages as $package)
                        <option value="{{ $package->id }}">{{ $package->name }}</option>
                    @endforeach
                </select>
            </div>

            <div>
                <label class="block text-gray-700">Reward Type</label>
                <select name="reward_type" class="form-control" required>
                    <option value="amount">Amount</option>
                    <option value="bonus">Bonus</option>
                    <option value="points">Points</option>
                </select>
            </div>

            <div>
                <label class="block text-gray-700">Reward Value</label>
                <input type="number" step="0.01" name="reward_value" class="form-control" required>
            </div>

            <div>
                <label class="block text-gray-700">Probability (%)</label>
                <input type="number" step="0.01" name="probability" class="form-control" required>
            </div>

            <div>
                <label class="block text-gray-700">Status</label>
                <select name="status" class="form-control" required>
                    <option value="1">Active</option>
                    <option value="0">Inactive</option>
                </select>
            </div>
        </div>

        <button type="submit" class="btn btn-primary mt-4">Create Spin</button>
    </form>
</div>
@endsection
