@extends('admin.partials.master')
@section('admin_content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4>Edit Task</h4>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.tasks.update', $task->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Title</label>
                            <input type="text" name="title" class="form-control" value="{{ $task->title }}" required>
                        </div>

                        <div class="form-group col-md-6">
                            <label>Package</label>
                            <select name="package_id" class="form-control" required>
                                <option value="">Select Package</option>
                                @foreach($packages as $package)
                                    <option value="{{ $package->id }}" @if($task->package_id == $package->id) selected @endif>
                                        {{ $package->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group col-md-6">
                            <label>Reward Amount</label>
                            <input type="number" step="0.01" name="reward_amount" class="form-control" value="{{ $task->reward_amount }}" required>
                        </div>

                        <div class="form-group col-md-6">
                            <label>Fake Downloads</label>
                            <input type="number" name="fake_downloads" class="form-control" value="{{ $task->fake_downloads }}" required>
                        </div>

                        <div class="form-group col-md-12">
                            <label>Description</label>
                            <textarea name="description" class="form-control" rows="4">{{ $task->description }}</textarea>
                        </div>

                        <div class="form-group col-md-6">
                            <label>Task Logo</label>
                            <input type="file" name="logo" class="form-control-file">
                            @if($task->logo)
                                <img src="{{ asset('storage/app/public/uploads/tasks/' . basename($task->logo)) }}" alt="logo" width="50" class="mt-2">
                            @endif
                        </div>

                        <div class="form-group col-md-6">
                            <label>Status</label>
                            <select name="status" class="form-control">
                                <option value="1" @if($task->status) selected @endif>Active</option>
                                <option value="0" @if(!$task->status) selected @endif>Locked</option>
                            </select>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary mt-3">Update Task</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
