@extends('admin.partials.master')
@section('admin_content')

<h2 class="text-center mb-4">User Investments</h2>

@if(session('success'))
<div class="alert alert-success">{{ session('success') }}</div>
@endif

<div class="table-responsive">
    <table class="table table-bordered table-striped table-hover">
        <thead class="thead-dark">
            <tr>
                <th>ID</th>
                <th>User</th>
                <th>Plan</th>
                <th>Amount</th>
                <th>Status</th>
                <th>Start</th>
                <th>End</th>
                <th>Last Earned At</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($investments as $inv)
            <tr>
                <td>{{ $inv->id }}</td>
                <td>{{ $inv->user->username ?? 'N/A' }}</td>
                <td>{{ $inv->plan->name ?? 'N/A' }}</td>
                <td>${{ $inv->amount }}</td>
                <td>
                    <form action="{{ route('admin.wealth.updateInvestmentStatus', $inv->id) }}" method="POST" class="d-flex gap-1 flex-wrap align-items-center">
                        @csrf
                        <select name="status" class="form-select form-select-sm">
                            <option value="1" @if($inv->status==1) selected @endif>Active</option>
                            <option value="0" @if($inv->status==0) selected @endif>Completed</option>
                        </select>
                        <button type="submit" class="btn btn-sm btn-primary">Update</button>
                    </form>
                </td>
                <td>{{ $inv->start_date }}</td>
                <td>{{ $inv->end_date }}</td>
                <td>{{ $inv->last_earned_at ?? 'N/A' }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>

<style>
/* Make table inputs scrollable horizontally on small screens */
.table-responsive {
    overflow-x: auto;
}

/* Adjust small screen layout */
@media (max-width: 576px) {
    table thead {
        font-size: 12px;
    }
    table tbody td {
        font-size: 12px;
        vertical-align: middle;
    }
    form.d-flex select, form.d-flex button {
        flex: 1 1 100%;
        font-size: 12px;
        margin-bottom: 3px;
    }
}
</style>

@endsection
