@extends('admin.partials.master')
@section('admin_content')

<h2 class="text-center mb-4">Manage Wealth Plans</h2>

@if(session('success'))
<div class="alert alert-success">{{ session('success') }}</div>
@endif
@if(session('error'))
<div class="alert alert-danger">{{ session('error') }}</div>
@endif

<div class="table-responsive">
    <table class="table table-bordered table-striped table-hover">
        <thead class="thead-dark">
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Min Amount</th>
                <th>Max Amount</th>
                <th>Description</th>
                <th>Days</th>
                <th>Profit %</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($plans as $plan)
            <tr>
                <td>{{ $plan->id }}</td>
                <td>
                    <form action="{{ route('admin.wealth.updatePlan', $plan->id) }}" method="POST" class="d-flex flex-wrap gap-2 align-items-center">
                        @csrf
                        <input type="text" name="name" value="{{ $plan->name }}" class="form-control form-control-sm" style="min-width:120px;" required>
                </td>
                <td><input type="number" name="min_amount" value="{{ $plan->min_amount }}" class="form-control form-control-sm" style="min-width:70px;" required></td>
                <td><input type="number" name="max_amount" value="{{ $plan->max_amount }}" class="form-control form-control-sm" style="min-width:70px;" required></td>
                <td><input type="text" name="description" value="{{ $plan->description }}" class="form-control form-control-sm" style="min-width:150px;"></td>
                <td><input type="number" name="days" value="{{ $plan->days }}" class="form-control form-control-sm" style="min-width:60px;" required></td>
                <td><input type="number" name="profit_percent" value="{{ $plan->profit_percent }}" class="form-control form-control-sm" style="min-width:60px;" step="0.01" required></td>
                <td>
                    <select name="status" class="form-select form-select-sm" style="min-width:80px;">
                        <option value="1" @if($plan->status==1) selected @endif>Active</option>
                        <option value="0" @if($plan->status==0) selected @endif>Inactive</option>
                    </select>
                </td>
                <td class="d-flex flex-wrap gap-1">
                        <button type="submit" class="btn btn-sm btn-primary mb-1">Update</button>
                    </form>
                    <form action="{{ route('admin.wealth.deletePlan', $plan->id) }}" method="POST" style="display:inline-block;">
                        @csrf
                        <button type="submit" class="btn btn-sm btn-danger mb-1" onclick="return confirm('Are you sure?')">Delete</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>

<h3 class="mt-4">Add New Plan</h3>
<form action="{{ route('admin.wealth.storePlan') }}" method="POST" class="d-flex flex-wrap gap-2 align-items-center">
    @csrf
    <input type="text" name="name" placeholder="Plan Name" class="form-control form-control-sm" required>
    <input type="number" name="min_amount" placeholder="Min Amount" class="form-control form-control-sm" required>
    <input type="number" name="max_amount" placeholder="Max Amount" class="form-control form-control-sm" required>
    <input type="text" name="description" placeholder="Description" class="form-control form-control-sm">
    <input type="number" name="days" placeholder="Days" class="form-control form-control-sm" required>
    <input type="number" name="profit_percent" placeholder="Profit %" class="form-control form-control-sm" step="0.01" required>
    <select name="status" class="form-select form-select-sm">
        <option value="1" selected>Active</option>
        <option value="0">Inactive</option>
    </select>
    <button type="submit" class="btn btn-success btn-sm">Add Plan</button>
</form>

@endsection

<style>
/* Optional: Make table inputs scrollable horizontally on small screens */
.table-responsive {
    overflow-x: auto;
}

/* Make inputs and buttons smaller on very small devices */
@media (max-width: 576px) {
    .table td input, .table td select {
        min-width: 60px !important;
        font-size: 12px;
        padding: 3px 5px;
    }
    .table td button {
        font-size: 12px;
        padding: 3px 5px;
    }
    form.d-flex input, form.d-flex select, form.d-flex button {
        flex: 1 1 100%;
    }
}
</style>
