<!doctype html>
<html lang="en">
<head>
   
   <style>
    /* Body & general page */
    body {
        font-family: 'Poppins', sans-serif;
        background: #f4f6f9;
        margin: 0;
        padding: 0;
        display: flex;
        justify-content: center;
        align-items: flex-start;
        min-height: 100vh;
    }

    /* Page container */
    .bankpage {
        width: 100%;
        max-width: 420px;
        margin: 2rem auto;
        background: #ffffff;
        border-radius: 12px;
        box-shadow: 0 10px 25px rgba(0,0,0,0.1);
        padding: 2rem 1.5rem;
        position: relative;
        overflow: hidden;
    }

    /* Background image overlay (optional) */
    .bankpage::after {
        content: "";
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 200px;
        background: url('{{ asset("public/IndustrialRobots/dist/img/1.c0ba8dc8.png") }}') no-repeat center center;
        background-size: cover;
        filter: hue-rotate(45deg);
        opacity: 0.15;
        z-index: -1;
        border-top-left-radius: 12px;
        border-top-right-radius: 12px;
    }

    /* Header/Nav bar */
    .van-nav-bar__title {
        font-size: 1.25rem;
        font-weight: 600;
        text-align: center;
        margin-bottom: 1rem;
    }

    .van-nav-bar__left {
        cursor: pointer;
        position: absolute;
        left: 1rem;
        top: 50%;
        transform: translateY(-50%);
        font-size: 1.2rem;
        color: #1989fa;
    }

    /* Section Box */
    .section-box {
        display: flex;
        flex-direction: column;
        gap: 1rem;
    }

    /* Input fields */
    .input-box input {
        width: 100%;
        padding: 0.75rem 1rem;
        border: 1px solid #ddd;
        border-radius: 8px;
        font-size: 1rem;
        outline: none;
        transition: all 0.2s;
    }

    .input-box input:focus {
        border-color: #1989fa;
        box-shadow: 0 0 5px rgba(25,137,250,0.3);
    }

    /* Labels */
    .accounti {
        font-size: 0.9rem;
        font-weight: 500;
        color: #555;
        margin-bottom: 0.25rem;
    }

    /* Tips / reminder */
    .tipsui {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        background: #eef6ff;
        padding: 0.75rem 1rem;
        border-radius: 8px;
        font-size: 0.85rem;
        color: #1989fa;
    }

    .welcome {
        font-size: 0.8rem;
        color: #888;
        text-align: center;
        margin: 0.5rem 0 1rem;
    }

    /* Submit Button */
    .btnposit {
        background: #1989fa;
        color: #fff;
        border: none;
        border-radius: 8px;
        padding: 0.75rem;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s;
        width: 100%;
    }

    .btnposit:hover {
        background: #1576d1;
    }

    /* Optional small images in header */
    .bankunt {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 1rem;
    }

    .bankunt p {
        font-size: 1.2rem;
        font-weight: 600;
        color: #333;
    }

    .bankunt img.imgui {
        width: 40px;
        height: 40px;
    }

    /* Responsive adjustments */
    @media (max-width: 480px) {
        .bankpage {
            margin: 1rem;
            padding: 1.5rem 1rem;
        }

        .van-nav-bar__title {
            font-size: 1.1rem;
        }

        .bankunt p {
            font-size: 1rem;
        }
    }
</style>

</head>
<body class="">
<div id="app" data-v-app="">
    @include('alert-message')
    <div>
        <form action="{{route('user.change.password.confirmation')}}" method="post">
            @csrf
            <div class="bankpage" data-v-45df3e73="">
                <div class="van-nav-bar van-hairline--bottom transparent" data-v-45df3e73="">
                    <div class="van-nav-bar__content">
                        <div class="van-nav-bar__left van-haptics-feedback" onclick="window.location.href='{{route('mine')}}'"><i
                                class="van-badge__wrapper van-icon van-icon-arrow-left van-nav-bar__arrow"><!----><!---->
                                <!----></i><!----></div>
                        <div class="van-nav-bar__title van-ellipsis">Password</div><!----></div>
                </div>
                <section class="section-box" data-v-45df3e73="">
                    <div class="bankunt" data-v-45df3e73=""><img class="imgl"
                                                                 
                                                                 alt="" data-v-45df3e73="">
                        <p data-v-45df3e73="">Change password</p><img class="imgui"
                                                                      src="{{asset('public')}}/IndustrialRobots/dist/img/1.2a3cfcca.png" alt=""
                                                                      data-v-45df3e73=""></div>
                    <p class="accounti" data-v-45df3e73="">Old password</p>
                    <div class="van-cell van-field input-box" data-v-45df3e73=""><!----><!---->
                        <div class="van-cell__value van-field__value">
                            <div class="van-field__body"><input type="password" id="van-field-15-input"
                                                                name="old_password"
                                                                class="van-field__control"
                                                                placeholder="Please enter old password"><!----><!---->
                                <!----></div><!----><!----></div><!----><!----></div>
                    <p class="accounti" data-v-45df3e73="">New password</p>
                    <div class="van-cell van-field input-box" data-v-45df3e73=""><!----><!---->
                        <div class="van-cell__value van-field__value">
                            <div class="van-field__body"><input type="password" id="van-field-16-input"
                                                                class="van-field__control"
                                                                name="new_password"
                                                                placeholder="Please enter new password"><!----><!---->
                                <!----></div><!----><!----></div><!----><!----></div>
                    <p class="accounti" data-v-45df3e73="">Confirm password</p>
                    <div class="van-cell van-field input-box" data-v-45df3e73=""><!----><!---->
                        <div class="van-cell__value van-field__value">
                            <div class="van-field__body"><input type="password" id="van-field-17-input"
                                                                class="van-field__control"
                                                                name="confirm_password"
                                                                placeholder="Enter new password again"><!----><!----><!---->
                            </div><!----><!----></div><!----><!----></div>
                    <div class="tipsui" data-v-45df3e73=""><img
                            src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAYAAACM/rhtAAAAAXNSR0IArs4c6QAABDlJREFUWEfVmX2IVFUUwH9nVslA19IEIyKhqCAqYd/M1irZB/0lUfRhREVCYaXt+kdQa4JYUFtBUJrbB4gIRZQSRcxfYVLQ2s68DVGCCgpDosLNVTfIxd135N6585qPN/vemxllev++c879vXPv+bjnCU08upUMq/EQbkfpAa4BLkVYYM0pk8AfwE8IYyhfkceXrQRpl5M0CnqQy5hmA8ojwOVpdIGjCB8whx2ynN+T6iYC1FEW08VLKI8DF0QYV4QTwCn3rhvlIiDK/hTCTmbYIr38HQcaC6gFHkR4G7ikwpgCBxC+IOAbMvwgHicrF1OfhQRcR4ZbUO4Cbq4BHkd5RnJ8PBtkQ0DdzxwWsA3lqdCwMIWym4A3pJef476+CniUq8nwLMJjaLgLxvPvMsmA3MZ0lL1IQB3hQuayB1hdobSPgPVpwWoX1RLoMHBHxbs8Z3hA+vi3Vr4O0HpuPp+FcMoMGTbTw+simK1t+VHjtzGeI+BlhC5nMM8/3FPryXpAn2GUp53SaZSHJcenLVNFRVaBexE+BObZ18I74rG+UrQK0AXER1bUeA7WJIXTAqsQrkLJS44/k36QGkj4xHlSUR6qDJwQ0KaSDD+G0SoMisdrSRbSAhsR3nSyf6EsTwXp8zzKq05/nIBryynoP0CfHWjo3n143Jn0zKnPQZQbKz7mCcmyM8nHGRl7Jn2+DANHGBaPDaVdNwKmQpzhF5uETSqZ4YY00apF9gL3hUDKrZLj66SAlsFEdxeHXAqaYi5XmopTAiwwhDDoDL4vWZ5MZbzAUpvMzRkM2CU53kqjX5bVIu8B61zADInHC+IK/xFXW9Xtf6ok3AxMlI7LkSYOjOOOkmeZaJEcMOoURiTLinYt2IwdLfIt0Od0e0V9BlGGnFs3iRdGU6x99VmJML9KcJpf05zf2kXqeLRoS9r9VlBZITlGYslK53YLwot1siZ/drFSevguiZ06wAJ9iPWiefaaLT4EXG/xhItru5JGi6jPLpS1Dd73S9Z2QKkf2wUpE+4cHjaAx2xyViYkx6KkFvV7ljDNABm6nfdNHlzljsqAeGxPaivCi8eNs4BxcwZNvTX57zfxWNa0UZ9+lG1tAfQ5gnKFycn/A8DyFgsT4iXf4ojoa6cHj6PlLW4ySM4VYFSQNJVmzhlgXZppIVFXQmqbgiQqUbel1LUNsK7UlaYELTcL7QCMbBZshfN5BWWT27JE7ZaOcRMB2xEWukRtLupLnI1j7iIPAadQ+qWXA3E5NrLdsoBNNKxVNTxuZWGPeKyZTWzWhtV5MVXLr0XuBnaD82DDos0kwqOS5fOGInEtvwVs4dIU58C495rk0mQhS3OYpq6dcRANvZf02lk2oJ18cbde7PTRh4Xs5OFRuNWdPH6rqrGdOsCsgkwyAlZOkHEj4IBu5DyNgKtAO3WIXtf7ncffEGcBV60t4f/CB9oAAAAASUVORK5CYII="
                            alt="" data-v-45df3e73="">
                        <p data-v-45df3e73="">Kind reminder</p></div>
                    <p class="welcome" data-v-45df3e73="">Do not share your password, keep it confidential to keep your
                        account secure.</p>
                    <button class="btnposit" data-v-45df3e73="" type="submit">Confirm Now</button>
                </section>
            </div>
        </form>

    </div><!----></div>
</body>
</html>
