<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Register</title>
  <div class="gtranslate_wrapper"></div>
<script>window.gtranslateSettings = {"default_language":"en","detect_browser_language":true,"languages":["en","ru","tr","hi","es","de","bg","fr","it","zh-TW"],
"wrapper_selector":".gtranslate_wrapper","horizontal_position":"right","vertical_position":"top"}</script>
<script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: Arial, sans-serif;
    }

    body {
      height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
      background: url("{{ asset('ch/bg.png') }}") no-repeat center center/cover;
      padding: 20px;
    }

    .container {
      width: 100%;
      max-width: 400px;
      text-align: center;
      position: relative;
    }

   

    .input-box {
      position: relative;
      background: #fff;
      border-radius: 30px;
      margin: 12px 0;
      display: flex;
      align-items: center;
      padding: 12px 15px;
      box-shadow: 0 2px 6px rgba(0,0,0,0.15);
    }

    .input-box input {
      border: none;
      outline: none;
      width: 100%;
      font-size: 14px;
      margin-left: 10px;
      background: transparent;
    }

    .btn {
      width: 100%;
      padding: 14px;
      border: none;
      border-radius: 30px;
      font-size: 16px;
      font-weight: bold;
      cursor: pointer;
      margin: 10px 0;
      transition: 0.3s ease;
    }

    .btn-register {
      background: #651054;
      color: #fff;
      box-shadow: 0 4px 8px rgba(0,0,0,0.2);
    }

    .btn-register:hover {
      background: #7a1b6f;
    }

    .language {
      position: absolute;
      top: 10px;
      right: 15px;
      color: #fff;
      font-size: 14px;
    }

    .back-arrow {
      position: absolute;
      top: 15px;
      left: 15px;
      font-size: 20px;
      color: #fff;
      cursor: pointer;
    }

    .info-box {
      background: rgba(255, 255, 255, 0.1);
      backdrop-filter: blur(12px);
      -webkit-backdrop-filter: blur(12px);
      padding: 20px;
      border-radius: 12px;
      text-align: center;
      margin-top: 20px;
      border: 1px solid rgba(255, 255, 255, 0.3);
    }

    .info-box p {
      color: #ffffff;
      font-size: 14px;
      line-height: 1.6;
      margin: 0;
    }

    @media (max-width: 480px) {
      .logo img { width: 90px; }
      .btn { font-size: 14px; padding: 12px; }
      .input-box { padding: 10px 12px; }
      .info-box p { font-size: 13px; }
    }

  .captcha-box {
  display: flex;
  align-items: center;
  justify-content: space-between;
}

.captcha-box input {
  flex: 1; /* input field full available width */
  margin-right: 10px;
  border: none;
  outline: none;
  padding: 10px 12px;
  border-radius: 30px;
  font-size: 14px;
}

.captcha-box img {
  height: 10px; /* default size */
  cursor: pointer;
  border-radius: 8px;
  border: 1px solid rgba(0,0,0,0.1);
}

/* Mobile responsiveness */
@media (max-width: 550px) {
  .captcha-box img {
    height: 35px; /* smaller on mobile */
  }

  .captcha-box input {
    font-size: 13px;
    padding: 8px 10px;
  }
}
.logo-box {
  width: 100%;
  background: #fff;
  border-radius: 30px;
  margin: 12px 0;
  padding: 3px 4px;   /* VERY SMALL padding */
  box-shadow: 0 2px 6px rgba(0,0,0,0.15);

  display: flex;
  justify-content: center;
  align-items: center;
}

.logo-box img {
  width: 100%;
  height: 140px;      /* INCREASED AGAIN */
  object-fit: cover; /* fills perfectly */
  border-radius: 26px;
}


  </style>




</head>
<body>
  

  <form action="{{ url('register') }}" method="post">
    @csrf
    <div class="container">
      <div class="logo-box">
  <img src="{{ asset('BBDO.jpg') }}" alt="Logo">
</div>


      <!-- Phone -->
      <!-- ✅ Include intl-tel-input CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.min.css"/>

<!-- ✅ Your Updated Input Box -->
<div class="input-box">
  <span>📱</span>
  <input id="phone" type="tel" name="phone" placeholder="Please enter your phone number">
</div>

<!-- ✅ Include intl-tel-input JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>

<!-- ✅ Initialize the Plugin -->
<script>
  const input = document.querySelector("#phone");
  const iti = window.intlTelInput(input, {
    initialCountry: "ke", // Default country (India)
    separateDialCode: true, // Show dial code separately
    preferredCountries: ["ke", "us", "bd", "pk"], // Top preferred countries
    utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js"
  });
</script>

      <!-- Password -->
      <div class="input-box">
        <span>🔒</span>
        <input type="password" name="password" placeholder="Please enter login password" required>
      </div>

      <!-- Confirm Password -->
      <div class="input-box">
        <span>🔒</span>
        <input type="password"  placeholder="Please confirm your password" required>
      </div>

   

      <!-- Invitation Code -->
      <div class="input-box">
        <span>🎁</span>
        <input type="text"  placeholder="Please enter the invitation code" name="ref_by"
                                           value="{{isset($ref_by) && !empty($ref_by) && $ref_by != null ? $ref_by : \App\Models\User::select('ref_id')->first()->ref_id}}">
      </div>

      <!-- Register Button with Spinner -->
      <button class="btn btn-register" id="registerBtn" type="submit">
        <span id="btnText">Register now</span>
        <span id="btnSpinner" style="display:none;">⏳</span>
      </button>

      <!-- Info box -->
      <div class="info-box">
        <p>Have an account? <a href="{{ route('login') }}" style="color: #fff; text-decoration: underline;">Login here</a> or download the APP</p>
      </div>
    </div>
  </form>
@include('alert-message')
  <script>
    // Button spinner
    const registerForm = document.querySelector('form');
    const registerBtn = document.getElementById('registerBtn');
    const btnText = document.getElementById('btnText');
    const btnSpinner = document.getElementById('btnSpinner');

    registerForm.addEventListener('submit', function(e){
      btnText.style.display = 'none';
      btnSpinner.style.display = 'inline-block';
      registerBtn.disabled = true;
    });

    // Refresh CAPTCHA
    const captchaImg = document.getElementById('captcha-img');
    captchaImg.addEventListener('click', function() {
        this.src = '{{ captcha_src() }}' + '?' + Date.now();
    });
  </script>
</body>
</html>
