<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Recharge Amount</title>
  </div>
<!-- Hide the GTranslate UI but keep functionality -->
<style>
  .gtranslate_wrapper {
    display: none !important;
  }
</style>

</div>
<div class="gtranslate_wrapper"></div>
<script>
  window.gtranslateSettings = {
    "default_language": "en",
    "detect_browser_language": true,
    "languages": ["en", "ru", "tr", "hi", "es", "de", "bg", "fr", "it", "zh-TW"],
    "wrapper_selector": ".gtranslate_wrapper",
    "horizontal_position": "right",
    "vertical_position": "top"
  };
</script>
<script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background:#f9f9f9; }
    .header { background:#4B0082; color:#fff; padding:15px; font-size:18px; display:flex; align-items:center; }
    .back-btn { color:#fff; text-decoration:none; margin-right:10px; font-size:20px; }
    .back-btn:hover { color:#d1c4e9; }
    .card-box { background:#fff; padding:20px; border-radius:12px; margin-top:20px; box-shadow:0 2px 6px rgba(0,0,0,0.1); }
    .btn-purple { background:#4B0082; color:#fff; font-weight:600; }
    .btn-purple:hover { background:#360061; color:#fff; }
    .info-box { background:#f3e9ff; padding:10px 15px; border-radius:8px; margin-bottom:15px; font-size:14px; color:#4B0082; }
    .info-item { margin-bottom:10px; display:flex; align-items:center; }
    .info-label { font-weight:600; margin-right:5px; width:100px; }
    .copy-btn { margin-left:10px; padding:2px 6px; font-size:12px; }
  </style>
</head>
<body>

  <div class="header">
    <a href="{{ route('recharge.index') }}" class="back-btn">&larr;</a>
    Recharge
  </div>

  <div class="container">
    <div class="card-box">
      <h5 class="mb-3">Enter Amount</h5>

      <!-- Payment Method Info (copyable) -->
      <div class="info-box">
        <div class="info-item">
          <span class="info-label">Channel:</span>
          <input type="text" class="form-control form-control-sm" value="{{ $method->channel }}" id="channel" readonly>
          <button class="btn btn-sm btn-outline-dark copy-btn" onclick="copyText('channel')">Copy</button>
        </div>
        <div class="info-item">
          <span class="info-label">Receiver:</span>
          <input type="text" class="form-control form-control-sm" value="{{ $method->receiver }}" id="receiver" readonly>
          <button class="btn btn-sm btn-outline-dark copy-btn" onclick="copyText('receiver')">Copy</button>
        </div>
        <div class="info-item">
          <span class="info-label">Address:</span>
          <input type="text" class="form-control form-control-sm" value="{{ $method->address }}" id="address" readonly>
          <button class="btn btn-sm btn-outline-dark copy-btn" onclick="copyText('address')">Copy</button>
        </div>
        <div class="info-item"><span class="info-label">Type:</span> {{ strtoupper($method->type) }}</div>
        <div class="info-item"><span class="info-label">Min:</span> {{ number_format($method->minimum,2) }}</div>
        <div class="info-item"><span class="info-label">Max:</span> {{ number_format($method->maximum,2) }}</div>
        <div class="info-item"><span class="info-label">Status:</span> {{ ucfirst($method->status) }}</div>
      </div>

      <!-- Deposit Form -->
      <form action="{{ route('recharge.confirm') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <input type="hidden" name="method_id" value="{{ $method->id }}">

        <div class="mb-3">
          <label class="form-label">Amount (KES)</label>
          <input type="number" name="amount" class="form-control"
                 min="{{ $method->minimum }}" max="{{ $method->maximum }}"
                 placeholder="Enter amount" required>
          <small class="text-muted">Min: {{ number_format($method->minimum,2) }} | Max: {{ number_format($method->maximum,2) }}</small>
        </div>

        <div class="mb-3">
          <label class="form-label">Transaction ID </label>
          <input type="text" name="transaction_id" class="form-control" placeholder="Enter transaction ID" required>
        </div>

        <button type="submit" class="btn btn-purple w-100 mb-2">Submit Deposit</button>
        <a href="{{ route('recharge.index') }}" class="btn btn-outline-dark w-100">Return</a>
      </form>
    </div>
  </div>

  <script>
    function copyText(id) {
      var copyInput = document.getElementById(id);
      copyInput.select();
      copyInput.setSelectionRange(0, 99999);
      navigator.clipboard.writeText(copyInput.value);
      alert(copyInput.value + " copied!");
    }
  </script>

</body>
</html>
