<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Wealth Management</title>
  <style>
    body {
      font-family: "Segoe UI", sans-serif;
      margin: 0;
      padding: 0;
      background: linear-gradient(135deg, #0f172a, #1e293b);
      color: #fff;
    }

    header {
      text-align: center;
      padding: 20px;
      background: rgba(0,0,0,0.3);
      font-size: 1.6rem;
      font-weight: bold;
      letter-spacing: 1px;
    }

    .container {
      max-width: 1000px;
      margin: 20px auto;
      padding: 15px;
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
      gap: 20px;
    }

    .card {
      background: rgba(255,255,255,0.05);
      border-radius: 16px;
      padding: 20px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.3);
      backdrop-filter: blur(8px);
      transition: transform 0.3s, box-shadow 0.3s;
    }

    .card:hover {
      transform: translateY(-6px);
      box-shadow: 0 8px 20px rgba(0,0,0,0.5);
    }

    .title {
      font-size: 1.3rem;
      font-weight: bold;
      margin-bottom: 10px;
      color: #38bdf8;
    }

    .detail {
      margin: 6px 0;
      font-size: 0.95rem;
    }

    .btn {
      margin-top: 15px;
      padding: 10px 18px;
      background: #2563eb;
      color: #fff;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      font-size: 0.95rem;
      transition: background 0.3s;
    }

    .btn:hover {
      background: #1d4ed8;
    }
  </style>
</head>
<body>
  <header>💼 Wealth Management Plans</header>

  <div class="container">

    <div class="card">
      <div class="title">BlackRock</div>
      <div class="detail">⏳ Storage period: <b>5 days</b></div>
      <div class="detail">💰 Profit: <b>1.3%</b></div>
      <button class="btn">Invest Now</button>
    </div>

    <div class="card">
      <div class="title">Morgan Stanley Investment Management</div>
      <div class="detail">⏳ Storage period: <b>30 days</b></div>
      <div class="detail">💰 Profit: <b>28%</b></div>
      <button class="btn">Invest Now</button>
    </div>

    <div class="card">
      <div class="title">Vanguard Group</div>
      <div class="detail">⏳ Storage period: <b>3 days</b></div>
      <div class="detail">💰 Profit: <b>1%</b></div>
      <button class="btn">Invest Now</button>
    </div>

  </div>
</body>
</html>
