<!DOCTYPE html>
<html lang="en">
<head>
    @include('app.layout.css')
</head>
<body>
@include('app.layout.loading')
<link rel="stylesheet" href="{{asset('public/spin/spain.css')}}">

<style>
    #spin-container {
        text-align: center;
        background: linear-gradient(rgba(139, 21, 154, .9), rgba(83, 17, 92, 1));
        padding: 20px;
    }
    #spinner {
        position: relative;
        display: inline-block;
    }
    #spin_round {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        cursor: pointer;
        width: 100px;
    }
</style>

<div class="spin_banner"
     style="background: linear-gradient(rgba(139, 21, 154, .4), rgba(139, 21, 154, 1)), url('{{asset('public/spin/image')}}/s_banner.jpg') no-repeat;
      background-size: cover">
    <div class="spin_back" onclick="window.location.href='{{route('dashboard')}}'">
        <i class="fa fa-chevron-left"></i>
    </div>
    <div>
        <h1 class="d_draw">Daily draw</h1>
        <h1 class="l_wheel">Lucky wheel</h1>
    </div>
</div>

<div id="spin-container">
    <div class="congregate">
        <p id="congratulations_user"></p>
    </div>

    <div id="spinner">
        <canvas id="spinWheel" width="400" height="400"></canvas>
        <img id="spin_round" onclick="spinToWin()" src="{{asset('public/spin/image')}}/draw-now.png">
    </div>

    <div class="lucky_count">
        <p>1 lucky draw left</p>
    </div>

    <div class="rules">
        <img class="ribbon" src="{{asset('public/spin/image')}}/ribbon3.png">
        <p class="activity_rules">Activity Rules</p>
    </div>

    <div class="activity_notice">
        <p>1. Har package pe ek hi spin milega.</p>
        <p>2. Agar pehle spin kar chuke ho toh dobara nahi milega.</p>
    </div>
</div>

<meta name="csrf-token" content="{{ csrf_token() }}" />
@include('alert-message')
@include('app.layout.manu')
@include('app.layout.js')

<script>
    // Fake congratulation text (demo)
    setInterval(function (){
        function rand(min, max) {
            return Math.floor(Math.random() * (max - min + 1) + min)
        }
        document.getElementById('congratulations_user').innerHTML =
            `🎉 Congratulations user${rand(1,99)} ${rand(100,999)}*****${rand(100,999)} for winning Tk.${rand(11,29)}.00`
    }, 2000)

    // === Spin Wheel Drawing ===
    const canvas = document.getElementById("spinWheel");
    const ctx = canvas.getContext("2d");
    const radius = canvas.width / 2;

    const prizes = @json($spins); // Laravel se spins table
    const sliceCount = prizes.length;
    const sliceAngle = 2 * Math.PI / sliceCount;

    function drawWheel() {
        for (let i = 0; i < sliceCount; i++) {
            let angle = i * sliceAngle;

            // Slice colors alternate
            ctx.fillStyle = i % 2 === 0 ? "#d63384" : "#6f42c1";
            ctx.beginPath();
            ctx.moveTo(radius, radius);
            ctx.arc(radius, radius, radius, angle, angle + sliceAngle);
            ctx.closePath();
            ctx.fill();

            // Text in slice
            ctx.save();
            ctx.translate(radius, radius);
            ctx.rotate(angle + sliceAngle / 2);
            ctx.textAlign = "right";
            ctx.fillStyle = "#fff";
            ctx.font = "16px Arial";
            ctx.fillText(prizes[i].reward_value + " " + prizes[i].reward_type, radius - 10, 5);
            ctx.restore();
        }
    }

    drawWheel();

    // === Spin Logic ===
    let currentRotation = 0;

    function spinToWin() {
        // Call backend to get real reward
        fetch("{{ route('user.spin.play') }}", {
            method: "POST",
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(res => res.json())
        .then(data => {
            if (!data.status) {
                message(data.message);
                return;
            }

            const reward = data.reward;
            const index = prizes.findIndex(p => p.id === reward.id);
            if (index === -1) {
                message("⚠️ Reward slice not found.");
                return;
            }

            // Slice angle
            const sliceDeg = 360 / sliceCount;
            const stopAngle = (index * sliceDeg) + (sliceDeg / 2);

            // Random extra spins
            const extraSpins = 5 * 360; // 5 rounds
            const targetRotation = extraSpins + (360 - stopAngle);

            // Animate wheel
            currentRotation += targetRotation;
            canvas.style.transition = "5s ease-out";
            canvas.style.transform = "rotate(" + currentRotation + "deg)";

            setTimeout(function(){
                message(data.message);
            }, 5200);

        })
        .catch(() => {
            message("⚠️ Kuch galti ho gayi, dobara try karein.");
        });
    }
</script>
</body>
</html>
