<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Daily Statement</title>
  <div class="gtranslate_wrapper"></div>
<script>window.gtranslateSettings = {"default_language":"en","detect_browser_language":true,"languages":["en","sw", "ru","tr","hi","es","de","bg","fr","it","zh-TW"],
"wrapper_selector":".gtranslate_wrapper","horizontal_position":"right","vertical_position":"top"}</script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

<script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>
<style>
  .gtranslate_wrapper {
    display: none !important;
  }
</style>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: Arial, sans-serif;
    }

    body {
      min-height: 100vh;
      background: url("{{asset('ch/bg.png')}}") no-repeat center center/cover;
      padding: 20px;
      color: #fff;
      position: relative;
    }

    .container {
      max-width: 1000px;
      margin: auto;
    }

    h1 {
      text-align: center;
      color: #fff;
      margin-bottom: 25px;
      font-size: 26px;
      text-shadow: 0 0 10px rgba(255,255,255,0.5);
    }

    /* Back Button */
    .back-btn {
      position: absolute;
      top: 20px;
      left: 20px;
      padding: 8px 16px;
      background: rgba(255, 255, 255, 0.1);
      backdrop-filter: blur(10px);
      border-radius: 30px;
      color: #fff;
      text-decoration: none;
      font-weight: bold;
      border: 1px solid rgba(255,255,255,0.3);
      box-shadow: 0 3px 8px rgba(0,0,0,0.3);
      transition: 0.3s;
    }

    .back-btn:hover {
      background: rgba(255, 255, 255, 0.2);
      box-shadow: 0 4px 12px rgba(0,0,0,0.5);
    }

    /* Glass effect card */
    .card {
      background: rgba(255, 255, 255, 0.1);
      backdrop-filter: blur(12px);
      -webkit-backdrop-filter: blur(12px);
      border-radius: 16px;
      padding: 20px;
      text-align: center;
      border: 1px solid rgba(255, 255, 255, 0.2);
      box-shadow: 0 4px 10px rgba(0,0,0,0.3);
      transition: 0.3s ease;
    }

    .card:hover {
      transform: translateY(-3px);
      box-shadow: 0 6px 15px rgba(0,0,0,0.5);
    }

    .cards-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
      gap: 15px;
      margin-bottom: 30px;
    }

    /* Table glass style */
    .table-box {
      background: rgba(255,255,255,0.08);
      backdrop-filter: blur(10px);
      border-radius: 16px;
      padding: 15px;
      border: 1px solid rgba(255,255,255,0.2);
      box-shadow: 0 3px 10px rgba(0,0,0,0.3);
    }

    table {
      width: 100%;
      border-collapse: collapse;
      text-align: center;
      color: #fff;
    }

    thead {
      background: rgba(255,255,255,0.15);
    }

    th, td {
      padding: 10px;
      font-size: 14px;
    }

    tr:nth-child(even) {
      background: rgba(255,255,255,0.05);
    }

    tr:hover {
      background: rgba(255,255,255,0.12);
    }

    /* Mobile responsive */
    @media (max-width: 600px) {
      h1 {
        font-size: 20px;
      }
      th, td {
        font-size: 12px;
        padding: 6px;
      }
    }
  </style>
</head>
<body>
  <!-- Back Button -->
  <a href="{{ url()->previous() }}" class="back-btn">⬅ Back</a>

  <div class="container">
    <h1>Daily Statement</h1>

    <!-- Summary Cards -->
    <div class="cards-grid">
      <div class="card">
        <p>Total Revenue (My Income)</p>
        <h2>{{ number_format($totalRevenue, 2) }}</h2>
      </div>
      <div class="card">
        <p>My Missions (Completed Tasks)</p>
        <h2>{{ $myMission }}</h2>
      </div>
      <div class="card">
        <p>Subordinate Tasks</p>
        <h2>{{ $subordinateOrders }}</h2>
      </div>
      <div class="card">
        <p>Subordinate Commission</p>
        <h2>{{ number_format($subordinateIncome, 2) }}</h2>
      </div>
    </div>

    <!-- Last 30 Days Table -->
    <div class="table-box">
      <h2 style="margin-bottom:10px;">Last 30 Days</h2>
      <table>
        <thead>
          <tr>
            <th>Date</th>
            <th>My Tasks</th>
            <th>My Task Income</th>
            <th>Subordinate Tasks</th>
            <th>Subordinate Commission</th>
          </tr>
        </thead>
        <tbody>
          @foreach($last30Days as $day)
            <tr>
              <td>{{ $day['date'] }}</td>
              <td>{{ $day['quantity'] }}</td>
              <td>{{ number_format($day['task_income'], 2) }}</td>
              <td>{{ $day['subordinate_quantity'] }}</td>
              <td>{{ number_format($day['subordinate_income'], 2) }}</td>
            </tr>
          @endforeach
        </tbody>
      </table>
    </div>
  </div>
</body>
</html>
