<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Video Tutorial</title>
  <div class="gtranslate_wrapper"></div>
<script>window.gtranslateSettings = {"default_language":"en","detect_browser_language":true,"languages":["en","sw", "ru","tr","hi","es","de","bg","fr","it","zh-TW"],
"wrapper_selector":".gtranslate_wrapper","horizontal_position":"right","vertical_position":"top"}</script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

<script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>
<style>
  .gtranslate_wrapper {
    display: none !important;
  }
</style>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: Arial, sans-serif;
    }

    body {
      min-height: 100vh;
      display: flex;
      justify-content: center;
      align-items: flex-start;
      background: url("{{asset ('ch/bg.png')}}") no-repeat center center/cover;
      padding: 20px;
    }

    .container {
      width: 100%;
      max-width: 800px;
      position: relative;
    }

    .header {
      display: flex;
      align-items: center;
      gap: 10px;
      margin-bottom: 20px;
    }

    .back-btn {
      font-size: 22px;
      font-weight: bold;
      color: rgba(247, 243, 243, 1);
      cursor: pointer;
      background: rgba(255,255,255,0.2);
      padding: 6px 12px;
      border-radius: 8px;
      transition: 0.3s;
    }

    .back-btn:hover {
      background: rgba(255,255,255,0.35);
    }

    .header h1 {
      font-size: 22px;
      font-weight: bold;
      color: #fff;
    }

    /* Glass effect box */
    .step-box {
      background: rgba(255, 255, 255, 0.1);
      backdrop-filter: blur(12px);
      -webkit-backdrop-filter: blur(12px);
      padding: 20px;
      border-radius: 12px;
      margin-bottom: 20px;
      border: 1px solid rgba(255, 255, 255, 0.3);
    }

    .step-box h3 {
      color: #fff;
      font-size: 18px;
      margin-bottom: 10px;
    }

    .step-box p {
      color: #f1f1f1;
      font-size: 14px;
      margin-bottom: 12px;
    }

    .step-box iframe,
    .step-box video {
      width: 100%;
      border-radius: 10px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.3);
    }

    /* Mobile responsive */
    @media (max-width: 480px) {
      .header h1 {
        font-size: 18px;
      }
      .step-box h3 {
        font-size: 16px;
      }
      .step-box p {
        font-size: 13px;
      }
    }
  </style>
</head>
<body>

  <div class="container">
    <!-- Header with Back Button -->
    <div class="header">
      <div class="back-btn" onclick="window.location.href='{{route('login')}}'">⬅</div>
      <h1>Video Tutorial (4 Steps)</h1>
    </div>


    <!-- Step 1 -->
    <div class="step-box">
      <h3>Step 1: Recharge</h3>
      <p>Learn how to Recharge easily.</p>
      <iframe src="https://www.youtube.com/embed/VIDEO_ID_1" frameborder="0" allowfullscreen></iframe>
    </div>

    <!-- Step 2 -->
    <div class="step-box">
      <h3>Step 2: How to invest</h3>
         <p>Learn how to invest easily.</p>
      <iframe src="https://www.youtube.com/embed/VIDEO_ID_2" frameborder="0" allowfullscreen></iframe>
    </div>




    <!-- Step 3 -->
    <div class="step-box">
      <h3>Step 3: Complete Tasks</h3>
      <p>Watch how to complete tasks and earn rewards.</p>
      <iframe src="https://www.youtube.com/embed/VIDEO_ID_3" frameborder="0" allowfullscreen></iframe>
    </div>

    <!-- Step 4 -->
    <div class="step-box">
      <h3>Step 4: Withdraw Earnings</h3>
      <p>Step-by-step guide to withdraw your earnings safely.</p>
      <iframe src="https://www.youtube.com/embed/VIDEO_ID_4" frameborder="0" allowfullscreen></iframe>
    </div>
  </div>

</body>
</html>
