<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>VIP Packages</title>
<style>
  * {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    font-family: Arial, sans-serif;
  }

  body {
    min-height: 100vh;
    background: url("{{asset('ch/bg.png')}}") no-repeat center center/cover;
    display: flex;
    flex-direction: column;
    align-items: center;
    padding: 20px;
    color: #fff;
  }

  /* Header */
  .header {
    width: 100%;
    max-width: 1100px;
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    margin-bottom: 30px;
  }

  .back-btn {
    position: absolute;
    left: 0;
    font-size: 24px;
    cursor: pointer;
    color: #fff;
  }

  .page-title {
    font-size: 22px;
    font-weight: bold;
    text-align: center;
  }

  /* Container for packages */
  .container {
    width: 100%;
    max-width: 1100px;
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
    gap: 20px;
  }

  .package-card {
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(12px);
    -webkit-backdrop-filter: blur(12px);
    border-radius: 20px;
    padding: 15px;
    border: 1px solid rgba(255,255,255,0.3);
    text-align: center;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    transition: 0.3s ease;
  }

  .package-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 4px 15px rgba(255, 255, 255, 0.2);
  }

  .package-card img {
    width: 100px;
    margin: 0 auto 10px;
  }

  .package-card h3 {
    font-size: 20px;
    margin-bottom: 8px;
  }

  .package-card .price {
    font-size: 18px;
    color: #1989fa;
    margin-bottom: 10px;
  }

  .package-info {
    font-size: 14px;
    margin-bottom: 12px;
    display: flex;
    justify-content: space-between;
  }

  .package-info span {
    font-weight: bold;
  }

  .package-btn {
    padding: 12px;
    border: none;
    border-radius: 30px;
    font-weight: bold;
    cursor: pointer;
    background: #651054;
    color: #fff;
    transition: 0.3s;
  }

  .package-btn:hover {
    background: #7a1b6f;
  }

  .invested-btn {
    background: #1989fa;
  }

  /* Modal styles */
  .modal {
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    background: rgba(255,255,255,0.1);
    backdrop-filter: blur(12px);
    -webkit-backdrop-filter: blur(12px);
    border-radius: 20px 20px 0 0;
    padding: 20px;
    display: none;
    z-index: 2000;
  }

  .modal.active {
    display: block;
  }

  .modal h3 {
    margin-bottom: 10px;
  }

  .modal .modal-btn, .modal .cancel-btn {
    width: 100%;
    padding: 12px;
    border-radius: 30px;
    font-weight: bold;
    margin-top: 10px;
    cursor: pointer;
    border: none;
  }

  .modal .modal-btn {
    background: #651054;
    color: #fff;
  }

  .modal .cancel-btn {
    background: red;
    color: #fff;
  }

  /* Responsive */
  @media (max-width: 480px) {
    .package-card img {
      width: 80px;
    }
    .package-card h3 {
      font-size: 16px;
    }
    .package-card .price {
      font-size: 16px;
    }
    .package-info {
      font-size: 12px;
    }
    .page-title {
      font-size: 18px;
    }
  }
</style>
</head>
<body>

<!-- Header with back button and title -->
<div class="header">
  <div class="back-btn" onclick="history.back()">&#8592;</div>
  <div class="page-title">Purchase VIP Package</div>
</div>

<div class="container">
  @foreach(\App\Models\Package::where('status', 'active')->get() as $element)
      <?php
          $myPackage = \App\Models\Purchase::where('user_id', auth()->id())->where('package_id', $element->id)->where('status', 'active')->first();
          $task = \App\Models\Task::first();
      ?>
      <div class="package-card">
          <img src="{{asset($element->photo)}}" alt="{{$element->name}}">
          <h3>{{$element->name}}</h3>
          <div class="price">{{price($element->price)}}</div>
     
          <div class="package-info"><span>Daily Tasks:</span><p>{{$element->task}}</p></div>
          <div class="package-info"><span>Orders Income:</span><p>{{price($task->amount * $element->task)}}</p></div>
        

          @if($myPackage)
            <button class="package-btn invested-btn" disabled>Invested</button>
          @else
            <button class="package-btn" onclick="openModal('modal{{$element->id}}')">Invest</button>
          @endif
      </div>

      <!-- Modal -->
      <div class="modal" id="modal{{$element->id}}">
          <h3>{{$element->name}}</h3>
          <p>Price: {{price($element->price)}}</p>
    
          <p>Daily Task: {{$element->task}}</p>
          <p>Orders Income: {{price($task->amount * $element->task)}}</p>
       
          <button class="modal-btn" onclick="window.location.href='{{route('purchase.confirmation', $element->id)}}'">Invest</button>
          <button class="cancel-btn" onclick="closeModal('modal{{$element->id}}')">Cancel</button>
      </div>
  @endforeach
</div>

<script>
  function openModal(id){
    document.getElementById(id).classList.add('active');
  }
  function closeModal(id){
    document.getElementById(id).classList.remove('active');
  }
</script>

</body>
</html>
