<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Confirm Payment</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    #timer { font-size: 22px; font-weight: bold; color: red; }
  </style>
</head>
<body class="bg-light">

<div class="container py-5">
  <h3 class="mb-4">Confirm Payment</h3>

  <div class="card p-3">
    <h5>Amount: <strong>{{ price($amount) }}</strong></h5>
    <p>Please transfer the amount within the time below, otherwise the order will be cancelled.</p>
    <div id="timer">30:00</div>
  </div>

  <div class="card mt-3 p-3">
    <h6>Payment Method</h6>
    <p><strong>{{ $method->name }}</strong></p>
    @if($method->bank_name)
      <p>Bank: {{ $method->bank_name }}</p>
    @endif
    @if($method->account_holder)
      <p>Account Holder: {{ $method->account_holder }}</p>
    @endif
    <p>Account: {{ $method->address }}</p>
    @if($method->qr_code)
      <img src="{{ asset($method->qr_code) }}" width="200" class="mt-2">
    @endif
  </div>

  <form action="{{ route('recharge.confirm.submit') }}" method="POST" enctype="multipart/form-data" class="mt-3">
    @csrf
    <input type="hidden" name="method_id" value="{{ $method->id }}">
    <input type="hidden" name="amount" value="{{ $amount }}">

    <div class="mb-3">
      <label class="form-label">Transaction ID / UTR</label>
      <input type="text" name="transaction_id" class="form-control" required>
    </div>

    <div class="mb-3">
      <label class="form-label">Upload Proof</label>
      <input type="file" name="photo" class="form-control" required>
    </div>

    <button type="submit" class="btn btn-success w-100">Confirm Payment</button>
    <a href="{{ route('recharge.index') }}" class="btn btn-danger w-100 mt-2">Cancel</a>
  </form>
</div>

<script>
  let timer = 30 * 60;
  const display = document.getElementById("timer");

  setInterval(() => {
    let minutes = Math.floor(timer / 60);
    let seconds = timer % 60;
    display.textContent = `${minutes}:${seconds < 10 ? "0" : ""}${seconds}`;
    if (timer > 0) timer--;
  }, 1000);
</script>

</body>
</html>
