<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Spins</title>
<style>
body { margin:0; font-family:sans-serif; background:#e0f7fa; }
header { background:#00ACC1; color:white; padding:20px; text-align:center; font-size:24px; font-weight:bold; }
.container { display:grid; grid-template-columns:repeat(auto-fit,minmax(250px,1fr)); gap:20px; padding:20px; }
.spin-card { background:white; padding:15px; border-radius:10px; box-shadow:0 3px 6px rgba(0,0,0,0.1); }
.spin-card h3 { margin:0 0 10px 0; font-size:18px; }
.spin-card p { margin:0; font-size:14px; }
.spin-card .used { color:red; font-weight:bold; }
.spin-card .unused { color:green; font-weight:bold; }
</style>
</head>
<body>
<header>My Spins</header>

<div class="container">
    @foreach($spins as $spin)
    <div class="spin-card">
        <h3>Reward: {{ $spin->reward }}</h3>
        <p>Status: <span class="{{ $spin->status }}">{{ ucfirst($spin->status) }}</span></p>
    </div>
    @endforeach
</div>
</body>
</html>
