<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Tasks</title>
</div>
<div class="gtranslate_wrapper"></div>
<script>window.gtranslateSettings = {"default_language":"en","detect_browser_language":true,"languages":["en","ru","tr","hi","es","de","bg","fr","it","zh-TW"],
"wrapper_selector":".gtranslate_wrapper","horizontal_position":"right","vertical_position":"top"}</script>
<script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>
<style>
body { margin:0; font-family:sans-serif; background:#f9fafb; }
header { background:#FF6B6B; color:white; padding:20px; text-align:center; font-size:24px; font-weight:bold; }
.container { display:grid; grid-template-columns:repeat(auto-fit,minmax(250px,1fr)); gap:20px; padding:20px; }
.task-card { background:white; padding:15px; border-radius:10px; box-shadow:0 3px 6px rgba(0,0,0,0.1); }
.task-card h3 { margin:0 0 5px 0; font-size:18px; color:#333; }
.task-card p { margin:0 0 5px 0; font-size:14px; color:#666; }
.task-card button { padding:8px 12px; background:#FF6B6B; color:white; border:none; border-radius:5px; cursor:pointer; margin-top:5px; }
.task-card .completed { background:green; color:white; padding:5px 10px; border-radius:5px; display:inline-block; margin-top:5px; }
</style>
</head>
<body>
<header>Tasks</header>

<div class="container">
    @foreach($tasks as $task)
    <div class="task-card">
        <h3>{{ $task->title }}</h3>
        <p>{{ $task->description }}</p>
        <p>App: {{ $task->app_title }} | Downloads: {{ $task->downloads }}</p>

        @if($task->status == 'doing')
        <form action="{{ route('tasks.complete', $task->id) }}" method="POST">
            @csrf
            <button type="submit">Install / Complete</button>
        </form>
        @else
        <span class="completed">Completed</span>
        @endif
    </div>
    @endforeach
</div>
</body>
</html>
