<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>About Us - BBDO</title>
  <link rel="stylesheet" href="style.css">
<div class="gtranslate_wrapper"></div>
<script>window.gtranslateSettings = {"default_language":"en","detect_browser_language":true,"languages":["en","sw", "ru","tr","hi","es","de","bg","fr","it","zh-TW"],
"wrapper_selector":".gtranslate_wrapper","horizontal_position":"right","vertical_position":"top"}</script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

<script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>
<style>
  .gtranslate_wrapper {
    display: none !important;
  }
</style>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: Arial, sans-serif;
    }

    body {
      min-height: 100vh;
      display: flex;
      justify-content: center;
      align-items: flex-start;
      background: url("<?php echo e(asset ('ch/bg.png')); ?>") no-repeat center center/cover;
      padding: 20px;
    }

    .container {
      width: 100%;
      max-width: 800px;
      position: relative;
    }

    .header {
      display: flex;
      align-items: center;
      gap: 10px;
      margin-bottom: 20px;
    }

    .back-btn {
      font-size: 22px;
      font-weight: bold;
      color: #fff;
      cursor: pointer;
      background: rgba(255,255,255,0.2);
      padding: 6px 12px;
      border-radius: 8px;
      transition: 0.3s;
    }

    .back-btn:hover {
      background: rgba(255,255,255,0.35);
    }

    .header h1 {
      font-size: 22px;
      font-weight: bold;
      color: #fff;
    }

    /* Glass effect box */
    .info-box {
      background: rgba(255, 255, 255, 0.1);
      backdrop-filter: blur(12px);
      -webkit-backdrop-filter: blur(12px);
      padding: 20px;
      border-radius: 12px;
      margin-bottom: 20px;
      border: 1px solid rgba(255, 255, 255, 0.3);
    }

    .info-box h2 {
      color: #fff;
      font-size: 20px;
      margin-bottom: 10px;
    }

    .info-box p {
      color: #f1f1f1;
      font-size: 14px;
      line-height: 1.6;
      margin-bottom: 10px;
    }

    .stats {
      display: flex;
      justify-content: space-between;
      flex-wrap: wrap;
      margin-top: 15px;
    }

    .stat {
      flex: 1 1 30%;
      background: rgba(255,255,255,0.15);
      margin: 5px;
      padding: 15px;
      border-radius: 10px;
      text-align: center;
      color: #fff;
    }

    .stat h3 {
      font-size: 18px;
      margin-bottom: 5px;
    }

    .stat p {
      font-size: 13px;
      opacity: 0.8;
    }

    /* Locations */
    .locations {
      display: flex;
      flex-wrap: wrap;
      gap: 10px;
      margin-top: 10px;
    }

    .location {
      background: rgba(255,255,255,0.15);
      padding: 10px 15px;
      border-radius: 8px;
      color: #fff;
      font-size: 14px;
    }

    /* Mobile responsive */
    @media (max-width: 480px) {
      .header h1 {
        font-size: 18px;
      }
      .info-box h2 {
        font-size: 16px;
      }
      .info-box p {
        font-size: 13px;
      }
      .stat h3 {
        font-size: 16px;
      }
      .stat p {
        font-size: 12px;
      }
      .location {
        font-size: 12px;
      }
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="header">
      <div class="back-btn" onclick="window.history.back()">&#8592;</div>
      <h1>About Us</h1>
    </div>

    <!-- Who We Are -->
    <div class="info-box">
      <h2>Who We Are</h2>
      <p>When we focus on mutual success, everyone wins. The flexibility to mobilize the right people to deliver unique solutions, an unwavering focus to delivering value to your business bottom line; and the capability to leverage innovation to meet emerging challenges and keep you at the fore. This is BBDO.</p>
      <p>As a company that is 100 percent employee-owned, we collaborate and innovate to help our partners thrive. Our culture of ownership drives your success.</p>
      <p>Whether you are in the buildings, civil, or industrial market, partnering with BBDO means you're gaining a proven, reliable and trusted full-service partner with a mobile network of more than 5,200 employees, experts and seasoned professionals across Canada, the United States, Australia and the Caribbean.</p>
      <p>From advanced digital construction technologies to innovative offsite modular manufacturing, to the cutting edge of sustainable construction, we lead the industry as we have for more than 100 years. We leverage the expertise from this vast experience to help our clients and partners build lasting legacies.</p>
    </div>

    <!-- Stats -->
    <div class="info-box">
      <h2>About Us</h2>
      <div class="stats">
        <div class="stat">
          <h3>119</h3>
          <p>Years in Operation</p>
        </div>
        <div class="stat">
          <h3>$8.3B+</h3>
          <p>Annual Construction Volume</p>
        </div>
        <div class="stat">
          <h3>#11</h3>
          <p>Rank in ENR's Top 400 Contractors</p>
        </div>
      </div>
    </div>

    <!-- Where We Work -->
    <div class="info-box">
      <h2>Where We Work</h2>
      <p>Helping you transform communities across the globe. BBDO ranks among the largest general contractors in the United States. No matter where or what you want to build, we mobilize the right experts and resources to drive value, deliver excellence and exceed your expectations.</p>
      <div class="locations">
        <div class="location">United States</div>
        <div class="location">Canada</div>
        <div class="location">Caribbean</div>
        <div class="location">Australia</div>
      </div>
    </div>


<!-- Team Section -->
<div class="info-box">
  <h2>Our Leadership</h2>
  <div class="team">
    <div class="team-member" style="transition: transform 0.3s; box-shadow: 0 4px 15px rgba(0,0,0,0.4);">
      <img src="https://tse2.mm.bing.net/th/id/OIP.QSZbJQ2xxk4dUlkDUXedDwHaHa?pid=Api&P=0&h=220" alt="CEO">
      <h4>Stephanie McCay</h4>
      <p>Chief Executive Officer</p>
    </div>
    <div class="team-member" style="transition: transform 0.3s; box-shadow: 0 4px 15px rgba(0,0,0,0.4);">
      <img src="https://tse3.mm.bing.net/th/id/OIP.ePcCZ-06TYBUODA8D1VjaQHaE7?pid=Api&P=0&h=220" alt="Founder of Services">
      <h4>Shane Jones</h4>
      <p>Founder of Services</p>
    </div>
  </div>
</div>

<style>
.team-member:hover {
  transform: translateY(-5px);
}
.team-member img {
  width: 120px;
  height: 120px;
  border-radius: 50%;
  border: 3px solid #00ff7f; /* neon green border */
  margin-bottom: 10px;
  object-fit: cover;
}
.team-member h4 {
  margin-bottom: 5px;
  font-size: 18px;
  color: #fff;
}
.team-member p {
  font-size: 14px;
  opacity: 0.8;
  color: #f1f1f1;
}
</style>



    <!-- Our Offices -->
    <div class="info-box">
      <h2>Our Offices</h2>
      <p>BBDO has more than 32 offices across 30+ cities. The BBDO family of companies is a group of independent construction companies in Canada, the United States, Australia and the Caribbean that carry out diverse operations in the buildings, civil, industrial and special project sectors.</p>
    </div>
  </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\Web165\resources\views/app/main/about.blade.php ENDPATH**/ ?>