<!DOCTYPE html>
<html lang="en">
<head>
    <?php echo $__env->make('app.layout.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>

<body>
<?php echo $__env->make('app.layout.loading', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<link rel="stylesheet" href="<?php echo e(asset('public/spin/spain.css')); ?>">

<style>
    #spin-container {
        text-align: center;
        background: linear-gradient(to bottom, 
            #8b159a 0%,   /* Dark Purple top */
            #ffffff 50%, /* White middle */
            #8b159a 100% /* Dark Purple bottom */
        );
        padding: 20px;
       
    }

    #spinner {
        display: flex;
        justify-content: center;
        align-items: center;
        position: relative;
    }

    #spinerImage {
        width: 320px;
        height: 320px;
    }

    #spin_round {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        cursor: pointer;
        width: 100px;
    }
</style>


<div class="spin_banner"
     style="background: linear-gradient(rgba(139, 21, 154, .4), rgba(139, 21, 154, 1)), url('<?php echo e(asset('public/spin/image')); ?>/s_banner.jpg') no-repeat;
      background-size: cover">
    <div class="spin_back" onclick="window.location.href='<?php echo e(route('dashboard')); ?>'">
        <i class="fa fa-chevron-left"></i>
    </div>
    <div>
        <h1 class="d_draw">Daily draw</h1>
        <h1 class="l_wheel">Lucky wheel</h1>
    </div>
</div>

<div id="spin-container">
    <div class="congregate">
        <p id="congratulations_user"></p>
    </div>

    <div id="spinner" class="spin-to-win">
        <div>
            <img id="spinerImage" src="<?php echo e(asset('122.png')); ?>" />
        </div>
        <div id="spin">
            <!-- Spin button direct play karega -->
            <img id="spin_round" onclick="spinToWin()" src="<?php echo e(asset('public/spin/image')); ?>/draw-now.png">
        </div>
    </div>

  
    <div class="rules">
        <img class="ribbon" src="<?php echo e(asset('public/spin/image')); ?>/ribbon3.png">
        <p class="activity_rules">Activity Rules</p>
    </div>

    <div class="activity_notice">
        <p>1. The spin lucky draw is only for paids user.</p>
        <p>2. The spins is valid for 1 time.</p>
    </div>

    <div class="rules">
        <img class="ribbon" src="<?php echo e(asset('public/spin/image')); ?>/ribbon3.png">
        <p class="activity_rules">Leader Board</p>
    </div>
</div>

<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('app.layout.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
    // Fake congratulation text
    setInterval(function (){
        function randomIntFromInterval(min, max) {
            return Math.floor(Math.random() * (max - min + 1) + min)
        }
        document.getElementById('congratulations_user').innerHTML =
            `Congratulations user${randomIntFromInterval(1,99)} ${randomIntFromInterval(100,999)}*****${randomIntFromInterval(100,999)} for get .${randomIntFromInterval(10,290)}.00`
    }, 2000)

    // Spin Animation + Backend Call
    var spinerImage = document.getElementById('spinerImage');
    var spinArrow = document.getElementById('spin_round');

    function spinToWin() {
        // random rotation for animation
        let value = Math.ceil(Math.random() * 4000);
        spinerImage.style.transition = '5s';
        spinerImage.style.transform = 'rotate('+ value +'deg)';

        // Backend call
        fetch("<?php echo e(route('user.spin.play')); ?>", {
            method: "POST",
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(res => res.json())
        .then(data => {
            setTimeout(function (){
                message(data.message);
            }, 5000);
        })
        .catch(() => {
            message("⚠️Some mistake again try");
        });
    }
</script>
<div class="spin-history" style="margin:20px;">
    <h3 style="text-align:center;color:#fff;margin-bottom:15px;">
        Your Spin History
    </h3>

    <div style="display:flex;flex-direction:column;gap:15px;" id="spinHistoryWrapper">
        <?php $__empty_1 = true; $__currentLoopData = $spinHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div style="
                display:flex;
                justify-content:space-between;
                background:rgba(255,255,255,0.15);
                backdrop-filter:blur(10px);
                border-radius:15px;
                padding:15px;
                align-items:center;
                box-shadow:0 8px 32px rgba(0,0,0,0.2);
                border:1px solid rgba(255,255,255,0.2);
            ">
                <div>
                    <div style="font-weight:bold;color:#ffdd57;">
                        Spin Code: <?php echo e($history->spin_code); ?>

                    </div>
                    <div style="color:#fff;margin-top:5px;">
                        <?php echo e($history->reward_value); ?>

                        
                    </div>
                </div>

                <div style="text-align:right;">
                    <div style="font-size:14px;color:#ddd;">
                        <?php echo e(\Carbon\Carbon::parse($history->created_at)->format('d-m-Y H:i')); ?>


                    </div>
                    <div style="color:#4caf50;margin-top:5px;">
                        Completed
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div style="text-align:center;color:#fff;">
                No spins yet.
            </div>
        <?php endif; ?>
    </div>
</div>

</body>
</html> <?php /**PATH C:\xampp\htdocs\Web165\resources\views/user/spins/index.blade.php ENDPATH**/ ?>