<?php $__env->startSection('admin_content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4 class="card-title">All Packages</h4>
                <a href="<?php echo e(route('admin.packages.create')); ?>" class="btn btn-primary">Add New Package</a>
            </div>
            <div class="card-body table-responsive">
                <table class="table table-striped table-bordered table-hover">
                    <thead class="thead-dark">
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Price</th>
                            <th>Per Task Income</th>
                            <th>Total Income</th>
                            <th>Daily Task Limit</th>
                            <th>Validity (Days)</th>
                            <th>Type</th>
                            <th>Spins Count</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($package->id); ?></td>
                            <td><?php echo e($package->name); ?></td>
                            <td><?php echo e($package->price); ?></td>
                            <td><?php echo e($package->per_task_income); ?></td>
                            <td><?php echo e($package->total_income); ?></td>
                            <td><?php echo e($package->daily_task_limit); ?></td>
                            <td><?php echo e($package->validity_days); ?></td>
                            <td><?php echo e(ucfirst($package->type)); ?></td>
                            <td><?php echo e($package->spins_count); ?></td>
                            <td>
                                <?php if($package->status): ?>
                                    <span class="badge badge-success">Active</span>
                                <?php else: ?>
                                    <span class="badge badge-danger">Inactive</span>
                                <?php endif; ?>
                                <?php if($package->is_locked): ?>
                                    <span class="badge badge-warning ml-1">Locked</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <!-- Edit -->
                                <a href="<?php echo e(route('admin.packages.edit', $package->id)); ?>" class="btn btn-sm btn-info mb-1">Edit</a>
                                
                                <!-- Delete -->
                                <form action="<?php echo e(route('admin.packages.destroy', $package->id)); ?>" method="POST" style="display:inline-block;">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger mb-1" onclick="return confirm('Are you sure?')">Delete</button>
                                </form>
                                
                                <!-- Lock/Unlock -->
                                <form action="<?php echo e(route('admin.packages.toggleLock', $package->id)); ?>" method="POST" style="display:inline-block;">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-sm <?php if($package->is_locked): ?> btn-success <?php else: ?> btn-warning <?php endif; ?> mb-1">
                                        <?php if($package->is_locked): ?> Unlock <?php else: ?> Lock <?php endif; ?>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.partials.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Web165\resources\views/admin/packages/index.blade.php ENDPATH**/ ?>