<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
<title>Task List</title>
</div>
<!-- Hide the GTranslate UI but keep functionality -->
<style>
  .gtranslate_wrapper {
    display: none !important;
  }
</style>

</div>
<div class="gtranslate_wrapper"></div>
<script>
  window.gtranslateSettings = {
    "default_language": "en",
    "detect_browser_language": true,
    "languages": ["en", "ru", "tr", "hi", "es", "de", "bg", "fr", "it", "zh-TW"],
    "wrapper_selector": ".gtranslate_wrapper",
    "horizontal_position": "right",
    "vertical_position": "top"
  };
</script>
<script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>
<style>
:root{
  --accent-1:#4f46e5;
  --accent-2:#6d28d9;
  --glass:rgba(255,255,255,0.08);
  --text-on-glass:#fff;
  --header-height:64px;
}
html,body{height:100%; margin:0; padding:0; width:100%; box-sizing:border-box;}
*, *::before, *::after{box-sizing:inherit;}
body{font-family:Inter,system-ui,sans-serif; min-height:100vh; background:url("<?php echo e(asset('ch/bg.png')); ?>") no-repeat center center/cover; background-attachment:fixed; display:flex; flex-direction:column; color:var(--text-on-glass);}
.header{position:fixed; top:0; left:0; right:0; height:var(--header-height); display:flex; align-items:center; gap:12px; padding:0 16px;  border-bottom:1px solid rgba(255,255,255,0.06); z-index:9999;}
.back-btn{display:inline-flex; align-items:center; gap:8px; background:linear-gradient(135deg,var(--accent-1),var(--accent-2)); border:none; color:#fff; padding:8px 12px; border-radius:10px; cursor:pointer; font-weight:600; font-size:14px;}
.header-title{flex:1; text-align:center; font-size:18px; font-weight:700; color:#fff; padding-right:48px;}
.main{width:100%; max-width:960px; margin:0 auto; padding:calc(var(--header-height)+18px) 16px 48px; flex:1;}
.task-container{width:100%; max-width:700px; margin:0 auto; padding:18px; background:var(--glass); border-radius:14px; backdrop-filter:blur(10px);}
.task-header{color:#fff; text-align:center; font-size:20px; font-weight:700; margin-bottom:14px;}
ul{list-style:none; padding:0; margin:0;}
.app-list-li{background:rgba(255,255,255,0.95); border-radius:12px; padding:12px; margin:12px 0; display:flex; flex-direction:column; align-items:flex-start; box-shadow:0 2px 6px rgba(0,0,0,0.12);}
.app-left{display:flex; align-items:center; gap:12px;}
.app-info{color:#222; font-size:14px;}
.app-info-name{font-weight:700; margin-bottom:4px;}
.app-info-size{font-size:12px; color:#666;}
.app-btn-down{background:linear-gradient(135deg,var(--accent-1),var(--accent-2)); color:#fff; padding:8px 14px; border-radius:16px; font-weight:600; font-size:14px; border:none; cursor:pointer; margin-top:8px;}
.progress-wrapper{width:100%; background:#ddd; border-radius:6px; overflow:hidden; margin-top:8px; position:relative; display:none;}
.progress-bar{width:0%; height:20px; background:linear-gradient(90deg,var(--accent-1),var(--accent-2)); transition:width 0.25s linear;}
.progress-text{position:absolute; top:50%; left:50%; transform:translate(-50%,-50%); font-size:12px; font-weight:bold; color:#fff;}
.filter-btn{padding:6px 12px; border-radius:8px; border:none; color:#fff; cursor:pointer;}
.filter-btn.available{background:#6d28d9;}
.filter-btn.completed{background:#4f46e5;}
@media (max-width:480px){.app-left{flex-direction:column; align-items:flex-start; gap:8px;}.app-btn-down{width:100%; text-align:center;}}
</style>
</head>
<body>
<header class="header">
  <button class="back-btn" onclick="window.location.href='<?php echo e(route('dashboard')); ?>'">Back</button>
  <div class="header-title">Task List</div>
</header>

<main class="main">
<div class="task-container">
  <div class="task-header"></div>
<br>
  <!-- Filters -->
  <div style="display:flex; justify-content:center; gap:12px; margin-bottom:16px;">
    <button class="filter-btn available" data-filter="available">Available</button>
    <button class="filter-btn completed" data-filter="completed">Completed</button>
  </div>

  <ul>
    <?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php
        $isCompleted = in_array($task->id, $userTasks);
        $app = [
          'name'=>$task->title ?? 'Task '.$task->id,
          'icon'=>$task->logo ?? '/default-task.png',
          'downloads'=>$task->fake_downloads ?? rand(500,5000)
        ];
      ?>

      <li class="app-list-li" data-status="<?php echo e($isCompleted ? 'completed' : 'available'); ?>">
        <div class="app-left">
          <img src="<?php echo e(asset('storage/app/public/uploads/tasks/' . basename($task->logo))); ?>" width="44" height="44"/>
          <div class="app-info">
            <div class="app-info-name"><?php echo e($app['name']); ?></div>
            <div class="app-info-size"><?php echo e($app['downloads']); ?> downloads this momths</div>
          </div>
        </div>

        <?php if(!$isCompleted): ?>
        <form method="POST" action="<?php echo e(route('user.tasks.complete', $task->id)); ?>">
          <?php echo csrf_field(); ?>
          <button type="button" class="app-btn-down start-install">Install</button>
        </form>
        <?php else: ?>
        <span style="color:green; font-weight:bold; margin-top:8px;">Completed ✅</span>
        <?php endif; ?>

        <div class="progress-wrapper">
          <div class="progress-bar"></div>
          <span class="progress-text">0%</span>
        </div>
      </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </ul>
</div>
</main>

<script>
const filterButtons = document.querySelectorAll('.filter-btn');
const taskItems = document.querySelectorAll('.app-list-li');

// Filter tasks
filterButtons.forEach(btn=>{
  btn.addEventListener('click',()=>{
    const filter = btn.dataset.filter;
    taskItems.forEach(item=>{
      if(filter==='available' && item.dataset.status==='available') item.style.display='flex';
      else if(filter==='completed' && item.dataset.status==='completed') item.style.display='flex';
      else item.style.display='none';
    });
  });
});

// Install progress simulation
document.querySelectorAll('.start-install').forEach(button=>{
  button.addEventListener('click',()=>{
    const li = button.closest('.app-list-li');
    const form = button.closest('form');
    const progressWrapper = li.querySelector('.progress-wrapper');
    const progressBar = li.querySelector('.progress-bar');
    const progressText = li.querySelector('.progress-text');

    // Hide button, show progress
    button.style.display = 'none';
    progressWrapper.style.display = 'block';

    let progress = 0;
    const interval = setInterval(()=>{
      progress += 5; // increase 5% every second
      progressBar.style.width = progress + "%";
      progressText.textContent = progress + "%";

      if(progress >= 100){
        clearInterval(interval);
        // Auto submit form when complete
        form.submit();
      }
    }, 1000); // 1000ms = 1s → 20s total for 100%
  });
});
</script>

<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\Web165\resources\views/user/tasks/index.blade.php ENDPATH**/ ?>