

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Credit Score</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <style>
    *{margin:0;padding:0;box-sizing:border-box;font-family:Arial,sans-serif}
    body{
      min-height:100vh;
      background:url("<?php echo e(asset('ch/bg.png')); ?>") no-repeat center center/cover;
      color:#fff; padding:20px;
    }
    .container{max-width:1100px;margin:0 auto}
    .back-btn{
      display:inline-block;margin-bottom:20px;padding:8px 16px;border-radius:30px;
      background:rgba(255,255,255,0.1);backdrop-filter:blur(10px);
      color:#fff;text-decoration:none;font-weight:bold;border:1px solid rgba(255,255,255,.3);
      box-shadow:0 3px 8px rgba(0,0,0,.3);transition:.25s
    }
    .back-btn:hover{background:rgba(255,255,255,0.2)}
    h1{text-align:center;margin-bottom:18px;font-size:28px;text-shadow:0 0 10px rgba(255,255,255,.6)}
    .subtitle{opacity:.9;text-align:center;margin-bottom:22px}
    .grid{display:grid;gap:18px;grid-template-columns:1.2fr 1fr;}
    @media(max-width:900px){.grid{grid-template-columns:1fr}}
    .card{
      background:rgba(255,255,255,0.08);border:1px solid rgba(255,255,255,.2);
      border-radius:16px;padding:18px;box-shadow:0 6px 16px rgba(0,0,0,.35);
      backdrop-filter:blur(12px);
    }
    .card h2{font-size:18px;margin-bottom:10px;text-shadow:0 0 6px rgba(255,255,255,.45)}
    .muted{opacity:.85;font-size:14px}
    .score-wrap{display:flex;align-items:center;gap:18px;flex-wrap:wrap}
    .ring{
      width:160px;height:160px;border-radius:50%;
      display:grid;place-items:center;
      background:conic-gradient(#6ee7ff calc(var(--score) * 1%), rgba(255,255,255,0.15) 0);
      position:relative;
      box-shadow:0 4px 18px rgba(0,0,0,.35), inset 0 0 20px rgba(255,255,255,.08);
      transition:.4s ease;
    }
    .ring::after{
      content:"";position:absolute;inset:10px;border-radius:50%;
      background:rgba(0,0,0,.25);border:1px solid rgba(255,255,255,.15);
      box-shadow:inset 0 6px 24px rgba(0,0,0,.45);
    }
    .ring-value{position:absolute;display:flex;flex-direction:column;align-items:center;z-index:2}
    .ring-value .big{font-size:34px;font-weight:800;letter-spacing:.5px}
    .ring-value .small{font-size:12px;opacity:.8;margin-top:2px}
    .badges{display:flex;gap:8px;flex-wrap:wrap;margin-top:10px}
    .badge{
      padding:6px 10px;border-radius:20px;font-size:12px;font-weight:bold;
      background:rgba(255,255,255,.12);border:1px solid rgba(255,255,255,.25);
      backdrop-filter:blur(10px)
    }
    .rules{display:grid;gap:10px;margin-top:8px}
    .rule{background:rgba(255,255,255,.07);border:1px solid rgba(255,255,255,.16);border-radius:12px;padding:12px}
    .records{display:grid;gap:10px;margin-top:10px}
    .record{display:flex;justify-content:space-between;gap:12px;align-items:center;background:rgba(255,255,255,.07);border:1px solid rgba(255,255,255,.16);border-radius:12px;padding:12px}
    .rec-left{display:flex;flex-direction:column}
    .rec-title{font-weight:bold}
    .rec-note{font-size:12px;opacity:.85}
    .rec-point{font-weight:800}
    .two-up{display:grid;grid-template-columns:1fr 1fr;gap:18px}
    @media(max-width:700px){.two-up{grid-template-columns:1fr}}
    .hint{margin-top:10px;font-size:12px;opacity:.9}
  </style>
</head>
<body>
  <div class="container">
    <a href="<?php echo e(url()->previous()); ?>" class="back-btn">← Back</a>
    <h1>My Credit</h1>
    <p class="subtitle">Current credit score: <b><?php echo e($creditScore); ?></b> points</p>

    <div class="grid">
      <!-- Left Card -->
      <div class="card">
        <h2>Current Score</h2>
        <div class="score-wrap">
          <div class="ring" style="--score: <?php echo e($creditScore); ?>;">
            <div class="ring-value">
              <div class="big"><?php echo e($creditScore); ?></div>
              <div class="small">/ 100</div>
            </div>
          </div>
          <div style="flex:1;min-width:220px">
            <p class="muted">Your credit score affects task income, eligibility, and withdrawals. Maintain a higher score by completing tasks on time and inviting quality subordinates.</p>
            <div class="badges">
              <span class="badge">Credit Note</span>
              <span class="badge">Score Policy</span>
            </div>
          </div>
        </div>
        <div class="two-up" style="margin-top:16px">
          <div class="rule">
            <b>Status:</b>
            <?php $s = $creditScore; ?>
            <?php if($s >= 3600): ?> Above expectations ✅ 
            <?php elseif($s >= 600): ?> Approaching expectations ⚠️
            <?php elseif($s >= 100): ?> Meeting expectations ❌
            <?php else: ?> Below expectations ❌
            <?php endif; ?>
          </div>
          <div class="rule">
            <b>Withdraw:</b>
            <?php if($s >= 9): ?> Allowed ✅ <?php else: ?> Not allowed ❌ <?php endif; ?>
          </div>
        </div>
        <p class="hint">Tip: Build score steadily—avoid policy violations and complete daily missions.</p>
      </div>

      <!-- Right Card: Rules -->
      <div class="card">
        <h2>Credit Score Rules</h2>
        <div class="rules">
          <div class="rule">1) Score <b>above 3800</b> points will receive <b>Ksh.50,000 per months</b>.</div>
          <div class="rule">2) Score <b>above 700</b> points will receive <b>Ksh. 15,000</b>.</div>
          <div class="rule">3) Score <b>above 200</b> points will receive <b>Ksh. 3,500</b>.</div>
          <div class="rule">4) <b>Bonus:</b> Invite subordinates to become <b>(P)</b> to get <b>+10, 2 and 1 points</b>respectively for each.</div>
        </div>
      </div>
    </div>
 
  <!-- Records -->
    <div class="two-up" style="margin-top:18px">
      <div class="card">
        <h2>Recent Credit Records</h2>
        <div class="records">
          <?php if(isset($creditRecords) && count($creditRecords) > 0): ?>
            <?php $__currentLoopData = $creditRecords; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <div class="record">
                <div class="rec-left">
                  <span class="rec-title"><?php echo e($rec['title']); ?></span>
                  <span class="rec-note"><?php echo e($rec['note']); ?></span>
                  <span class="rec-note"><?php echo e(\Carbon\Carbon::parse($rec['date'])->format('Y-m-d H:i')); ?></span>
                </div>
                <div class="rec-point" style="color:#6ee7ff"><?php echo e($rec['delta'] > 0 ? '+' : ''); ?><?php echo e($rec['delta']); ?></div>
              </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          <?php else: ?>
            <p class="muted">No credit changes yet.</p>
          <?php endif; ?>
        </div>
      </div>



 
      <div class="card">
        <h2>How to Increase Score</h2>
        <div class="rules">
          <div class="rule">Complete daily tasks consistently.</div>
          <div class="rule">Avoid cancellations and violations.</div>
          <div class="rule">Invite active subordinates; each (P) = +10 point.</div>
          <div class="rule">Maintain activity for better trust.</div>
        </div>
      </div>
    </div>
  </div>
</body>
</html>

<?php /**PATH C:\xampp\htdocs\Web165\resources\views/user/credit.blade.php ENDPATH**/ ?>