<!DOCTYPE html>
<html lang="en">
<head>
    <title>Safe-payment</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
    <style>
        *{margin:0;padding:0;box-sizing:border-box;font-family:Arial,sans-serif;}
        body{
            background: url("<?php echo e(asset('ch/bg.png')); ?>") no-repeat center center/cover;
            min-height:100vh;
            color:#fff;
            display:flex;
            justify-content:center;
            padding:20px;
        }

        .container{
            width:100%;
            max-width:450px;
        }

        .header{
            display:flex;
            justify-content:center;
            align-items:center;
            margin-bottom:20px;
        }
        .header h4{
            font-size:18px;
            font-weight:bold;
            text-shadow: 0 0 6px #651054, 0 0 10px #ff00ff;
        }

        .card{
            background: rgba(255,255,255,0.1);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            border-radius:15px;
            border:1px solid rgba(255,255,255,0.3);
            padding:15px;
            margin-bottom:20px;
        }

        .card img{
            width:80px;
            margin-bottom:15px;
        }

        .header_count{
            text-align:center;
            font-weight:bold;
            color:#fff;
            text-shadow: 0 0 6px #651054, 0 0 10px #ff00ff;
        }

        #timer{
            font-size:22px;
            font-weight:bold;
            text-align:center;
            display:block;
            margin-top:10px;
            text-shadow: 0 0 6px #ff00ff, 0 0 12px #ff00ff;
        }
        #timer .time{
            display:inline-block;
            min-width:30px;
        }

        button{
            display:block;
            width:100%;
            padding:12px;
            border-radius:30px;
            border:none;
            margin-top:10px;
            font-weight:bold;
            cursor:pointer;
            background:#651054;
            color:#fff;
            text-shadow: 0 0 6px #ff00ff, 0 0 10px #ff99ff;
            transition:0.3s;
        }
        button:hover{
            background:#7a1b6f;
        }
    </style>
</head>
<body>

<div class="container">
    <div class="header">
        <h4>Payment Result</h4>
    </div>

    <div class="card">
        <div style="text-align: center;">
            <img src="<?php echo e(asset('public/check.png')); ?>" alt="Success">
        </div>
        <p class="header_count">Submit Success</p>
      
    </div>

    <button onclick="window.location.href='<?php echo e(route('history')); ?>'">History</button>
</div>

<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
    // Countdown Timer
    const timerContainer = document.getElementById('timer');
    let s = parseInt(timerContainer.getAttribute('data-seconds')),
        m = parseInt(timerContainer.getAttribute('data-minutes')),
        h = parseInt(timerContainer.getAttribute('data-hours'));

    function checkValue(v){ return v<10 ? "0"+v:v; }

    function countdown(){
        if(s>0){ s--; }
        else{ s=59; if(m>0){ m--; } else{ m=59; if(h>0){ h--; } else{ clearInterval(timerInterval); return; }}} 
        timerContainer.textContent = checkValue(m)+":"+checkValue(s);
    }
    let timerInterval = setInterval(countdown, 1000);
</script>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\Web165\resources\views/app/main/deposit/recharge_success.blade.php ENDPATH**/ ?>