<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover" />
  <title>Team • Mobile Web UI</title>
  </div>
<!-- Hide the GTranslate UI but keep functionality -->
<style>
  .gtranslate_wrapper {
    display: none !important;
  }
</style>

</div>
<div class="gtranslate_wrapper"></div>
<script>
  window.gtranslateSettings = {
    "default_language": "en",
    "detect_browser_language": true,
    "languages": ["en", "ru", "tr", "hi", "es", "de", "bg", "fr", "it", "zh-TW"],
    "wrapper_selector": ".gtranslate_wrapper",
    "horizontal_position": "right",
    "vertical_position": "top"
  };
</script>
<script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>
  <style>
    :root{
      --bg:#651054; --card:#fff; --text:#0f172a; --sub:#6b7280;
      --brand:#651054; --accent:#f97316; --muted:#f3f4f6;
      --shadow:0 6px 20px rgba(0,0,0,.12); --radius:18px;
    }
    *{box-sizing:border-box;margin:0;padding:0;font-family:"Segoe UI",Arial,sans-serif}
    body{min-height:100vh;display:flex;flex-direction:column;
      background:linear-gradient(140deg,rgba(101,16,84,.95),rgba(123,31,162,.9),rgba(236,72,153,.85)),
      url("<?php echo e(asset('ch/bg.png')); ?>") no-repeat center/cover;
      background-blend-mode:overlay; color:var(--text);
    }
    .app{flex:1;max-width:600px;margin:0 auto;width:100%;display:flex;flex-direction:column}

    /* Header */
    .hero{padding:22px;color:#fff}
    .hero .title{font-size:1.4rem;font-weight:600}
    .back{width:38px;height:38px;display:flex;align-items:center;justify-content:center;border-radius:50%;
      background:rgba(255,255,255,.15);cursor:pointer}
    .hero-grid{margin-top:18px;display:grid;grid-template-columns:repeat(auto-fit,minmax(100px,1fr));gap:12px;text-align:center}
    .hero-metric{font-size:.8rem;opacity:.85}
    .hero-value{font-size:1.5rem;font-weight:700}

    /* Tabs */
    .tabs{padding:12px}
    .segmented{display:flex;background:var(--muted);padding:4px;border-radius:var(--radius)}
    .tab{flex:1;padding:10px;border:none;background:none;font-size:.9rem;font-weight:600;
      border-radius:var(--radius);cursor:pointer}
    .tab.active{background:var(--brand);color:#fff;box-shadow:var(--shadow)}

    /* Filters */
    .filters{display:none;gap:8px;padding:12px;flex-wrap:wrap}
    .filters.show{display:flex}
    .input{flex:1;min-width:120px;padding:10px;border:1px solid #e5e7eb;border-radius:var(--radius);font-size:.85rem}
    .btn{background:var(--brand);color:#fff;padding:10px 16px;border:none;border-radius:var(--radius);cursor:pointer;font-weight:600}

    /* Cards */
    .grid{padding:12px;display:grid;grid-template-columns:repeat(auto-fit,minmax(150px,1fr));gap:12px}
    .card{background:var(--card);border-radius:var(--radius);padding:16px;box-shadow:var(--shadow);text-align:center}
    .label{font-size:.85rem;color:var(--sub)} .number{font-size:1.3rem;font-weight:700;color:var(--brand)}

    /* Pills */
    .pills{display:none;gap:8px;padding:12px;overflow-x:auto}
    .pills.show{display:flex}
    .pill{flex:1;padding:10px 14px;border:none;border-radius:50px;background:var(--muted);
      font-size:.85rem;font-weight:600;cursor:pointer;white-space:nowrap}
    .pill.active{background:var(--accent);color:#fff;box-shadow:var(--shadow)}

    /* Members */
    .members{display:none;flex-direction:column;gap:10px;padding:12px}
    .members.show{display:flex}
    .member-card{background:#fff;border-radius:12px;box-shadow:0 4px 10px rgba(0,0,0,.08);padding:12px;display:flex;justify-content:space-between;align-items:center}
    .member-card .name{font-weight:600;color:#651054}
    .member-card .phone,.member-card .id{font-size:.8rem;color:#6b7280}

    /* Bottom Nav */
    .bottom{position:sticky;bottom:0;background:#fff;box-shadow:0 -3px 12px rgba(0,0,0,.08);border-top-left-radius:16px;border-top-right-radius:16px}
    .dock{display:flex;justify-content:space-around;align-items:center;padding:8px 0}
    .dock a{flex:1;text-align:center;text-decoration:none;color:var(--sub);font-size:.75rem;font-weight:600}
    .dock a.active{color:var(--brand)}
  </style>
</head>
<body>
  <div class="app">
    <!-- Header -->
    <header class="hero">
      <div style="display:flex; align-items:center; gap:12px;">
        <div class="back" onclick="window.location.href='<?php echo e(route ('mine')); ?>'">
          <svg class="ico" viewBox="0 0 24 24" fill="none" stroke="#fff" stroke-width="2"><path d="M15 18l-6-6 6-6"/></svg>
        </div>
        <div class="title">Team</div>
      </div>
    </header>

    <!-- Tabs -->
    <section class="tabs">
      <div class="segmented">
        <button id="tabOverview" class="tab active" onclick="switchTab('overview')">Team Overview</button>
        <button id="tabMyTeam" class="tab" onclick="switchTab('myteam')">My Team</button>
      </div>
    </section>

 <!-- Overview Section -->
<section id="overviewSection">
  <div class="hero-grid">
    <div><div class="hero-metric" style="color:white;">Total Team</div><div class="hero-value" style="color:white;"><?php echo e($team_size); ?></div></div>
    <div><div class="hero-metric" style="color:white;">Level A</div><div class="hero-value" style="color:white;"><?php echo e($first_level_users->count()); ?></div></div>
    <div><div class="hero-metric" style="color:white;">Level B</div><div class="hero-value" style="color:white;"><?php echo e($second_level_users->count()); ?></div></div>
    <div><div class="hero-metric" style="color:white;">Level C</div><div class="hero-value" style="color:white;"><?php echo e($third_level_users->count()); ?></div></div>
  </div>

  <section class="grid">
    <article class="card"><div class="label">Team Members</div><div class="number"><?php echo e($team_size); ?></div></article>
    <article class="card"><div class="label">Active Members</div><div class="number"><?php echo e($activeMembers1 + $activeMembers2 + $activeMembers3); ?></div></article>

    <!-- Recharge -->
    <article class="card"><div class="label">Level A (Recharge)</div><div class="number"><?php echo e($lv1Recharge); ?></div></article>
    <article class="card"><div class="label">Level B (Recharge)</div><div class="number"><?php echo e($lv2Recharge); ?></div></article>
    <article class="card"><div class="label">Level C (Recharge)</div><div class="number"><?php echo e($lv3Recharge); ?></div></article>
    <article class="card"><div class="label">Total Recharge</div><div class="number"><?php echo e($lvTotalDeposit); ?></div></article>

    <!-- Withdraw -->
    <article class="card"><div class="label">Level A (Withdraw)</div><div class="number"><?php echo e($lv1Withdraw); ?></div></article>
    <article class="card"><div class="label">Level B (Withdraw)</div><div class="number"><?php echo e($lv2Withdraw); ?></div></article>
    <article class="card"><div class="label">Level C (Withdraw)</div><div class="number"><?php echo e($lv3Withdraw); ?></div></article>
    <article class="card"><div class="label">Total Withdraw</div><div class="number"><?php echo e($lvTotalWithdraw); ?></div></article>
  </section>
</section>
<section id="myTeamSection" style="display:none;">
  <!-- Filters -->
  <div class="filters">
    <input class="input" type="date"/>
    <input class="input" type="date"/>
    <button class="btn">Search</button>
  </div>

  <!-- Pills -->
  <nav class="pills">
    <button id="btnLevel1" class="pill active" onclick="showMembers('1', event)">Level A</button>
    <button class="pill" onclick="showMembers('2', event)">Level B</button>
    <button class="pill" onclick="showMembers('3', event)">Level C</button>
    <button class="pill" onclick="showMembers('Total', event)">Total</button>
  </nav>

  <!-- Members List -->
  <section id="memberList" class="members show">
    <!-- Initially empty, will be filled by showMembers() -->
  </section>
</section>

<style>
.members {
  padding:12px;
  display:flex;
  flex-direction:column;
  gap:10px;
}
.member-card {
  background:#fff;
  border-radius:12px;
  box-shadow:0 4px 10px rgba(0,0,0,.08);
  padding:12px;
  display:flex;
  justify-content:space-between;
  align-items:flex-start;
  flex-wrap:wrap;
}
.member-card .info {
  font-size:.85rem;
  color:#0f172a;
  flex:1;
}
.member-card .phone,
.member-card .balance,
.member-card .credit,
.member-card .deposit {
  font-size:.8rem;
  margin-bottom:3px;
}
.member-card .balance { color:#059669; } /* green */
.member-card .credit { color:#2563eb; }  /* blue */
.member-card .deposit { color:#9333ea; } /* purple */
.member-card .status {
  margin-top:4px;
  font-size:.8rem;
  color:#f59e0b; /* amber */
  font-weight:600;
}
</style>
<script>
function switchTab(tab){
  document.getElementById('tabOverview').classList.remove('active');
  document.getElementById('tabMyTeam').classList.remove('active');
  document.getElementById('overviewSection').style.display='none';
  document.getElementById('myTeamSection').style.display='none';
  if(tab==='overview'){
    document.getElementById('tabOverview').classList.add('active');
    document.getElementById('overviewSection').style.display='block';
  } else {
    document.getElementById('tabMyTeam').classList.add('active');
    document.getElementById('myTeamSection').style.display='block';
    document.querySelector('.filters').classList.add('show');
    document.querySelector('.pills').classList.add('show');
    document.querySelector('.members').classList.add('show');

    // Default show Level A members
    showMembers('1');
  }
}

function showMembers(level, ev=null){
  document.querySelectorAll('.pill').forEach(p=>p.classList.remove('active'));
  if(ev) ev.target.classList.add('active');
  let list=document.getElementById('memberList'); 
  list.innerHTML='';

  if(level==='1'){
    <?php $__currentLoopData = $first_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      list.innerHTML+=`
        <div class="member-card">
          <div class="info">
            <div class="phone">📞 <?php echo e($m->phone); ?></div>
            <div class="balance">💰 Balance: <?php echo e(number_format($m->balance,2)); ?></div>
            <div class="credit">⭐ Credit: <?php echo e($m->credit_score); ?></div>
            <div class="deposit">📥 Deposit: <?php echo e(\App\Models\Deposit::where('status', 'approved')->where('user_id', $m->id)->sum('amount')); ?></div>
          </div>
          <div class="status"><?php echo e($m->status ?? 'Active'); ?></div>
        </div>`;
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  }
  else if(level==='2'){
    <?php $__currentLoopData = $second_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      list.innerHTML+=`
        <div class="member-card">
          <div class="info">
            <div class="phone">📞 <?php echo e($m->phone); ?></div>
            <div class="balance">💰 Balance: <?php echo e(number_format($m->balance,2)); ?></div>
            <div class="credit">⭐ Credit: <?php echo e($m->credit_score); ?></div>
            <div class="deposit">📥 Deposit: <?php echo e(\App\Models\Deposit::where('status', 'approved')->where('user_id', $m->id)->sum('amount')); ?></div>
          </div>
          <div class="status"><?php echo e($m->status ?? 'Active'); ?></div>
        </div>`;
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  }
  else if(level==='3'){
    <?php $__currentLoopData = $third_level_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      list.innerHTML+=`
        <div class="member-card">
          <div class="info">
            <div class="phone">📞 <?php echo e($m->phone); ?></div>
            <div class="balance">💰 Balance: <?php echo e(number_format($m->balance,2)); ?></div>
            <div class="credit">⭐ Credit: <?php echo e($m->credit_score); ?></div>
            <div class="deposit">📥 Deposit: <?php echo e(\App\Models\Deposit::where('status', 'approved')->where('user_id', $m->id)->sum('amount')); ?></div>
          </div>
          <div class="status"><?php echo e($m->status ?? 'Active'); ?></div>
        </div>`;
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  }
  else{
    <?php $__currentLoopData = $first_level_users->merge($second_level_users)->merge($third_level_users); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      list.innerHTML+=`
        <div class="member-card">
          <div class="info">
            <div class="phone">📞 <?php echo e($m->phone); ?></div>
            <div class="balance">💰 Balance: <?php echo e(number_format($m->balance,2)); ?></div>
            <div class="credit">⭐ Credit: <?php echo e($m->credit_score); ?></div>
            <div class="deposit">📥 Deposit: <?php echo e(\App\Models\Deposit::where('status', 'approved')->where('user_id', $m->id)->sum('amount')); ?></div>
          </div>
          <div class="status"><?php echo e($m->status ?? 'Active'); ?></div>
        </div>`;
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  }
}
</script>
<?php /**PATH C:\xampp\htdocs\Web165\resources\views/app/main/team/index.blade.php ENDPATH**/ ?>