<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Deposit via <?php echo e($method->channel); ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
  <style>
    body { background-color: #930912ff; color: #fff; font-family: Arial, sans-serif; display: flex; justify-content: center; padding: 20px; }
    .container-box { width: 100%; max-width: 400px; }
    .card-box { background-color: #1c0da3ff; padding: 20px; border-radius: 12px; text-align: center; }
    .card-box h2 { font-size: 16px; margin-bottom: 20px; color: #fff; }
    .qr-box {
  background: #fff;
  padding: 15px;
  border-radius: 12px;
  margin-bottom: 15px;
  width: 180px;
  height: 180px;
  margin-left: auto;
  margin-right: auto;
  display: flex;
  align-items: center;
  justify-content: center;
}

    .address-box { display: flex; align-items: center; margin-bottom: 15px; background-color: #0B1C1E; border: 1px solid #1AA39D; border-radius: 6px; padding: 10px; font-size: 14px; color: #fff; }
    .address-box input { background: transparent; border: none; outline: none; color: #fff; flex: 1; }
    .copy-btn { background-color: #1AA39D; border: none; color: #fff; padding: 5px 10px; border-radius: 6px; cursor: pointer; margin-left: 5px; }
    .copy-btn:hover { background-color: #0e8b83; }
    .form-control { background-color: #0B1C1E; border: 1px solid #1AA39D; color: #fff; border-radius: 6px; margin-bottom: 15px; }
    .form-control::placeholder { color: #7FC7C0; }
    .btn-submit { background-color: #1AA39D; border: none; color: #fff; font-weight: 600; width: 100%; padding: 12px; border-radius: 25px; font-size: 16px; cursor: pointer; }
    .btn-submit:hover { background-color: #0e8b83; }
    .back-btn { color: #1AA39D; text-decoration: none; display: inline-block; margin-bottom: 15px; font-weight: 600; }
    .back-btn:hover { color: #0e8b83; }
  </style>
</head>
<body>

<div class="container-box">
  <a href="<?php echo e(route('recharge.index')); ?>" class="back-btn">&larr; Back to deposits</a>

  <div class="card-box">
    <h2>Deposit via <?php echo e($method->channel); ?></h2>

    <!-- Fake QR Code -->
    <div class="qr-box" id="qrcode"></div>

    <!-- Real Recharge Address -->
    <div class="address-box">
      <input type="text" id="walletAddress" value="<?php echo e($method->address); ?>" readonly>
      <button class="copy-btn" onclick="copyAddress()">Copy</button>
    </div>

    <!-- Deposit Form -->
    <form action="<?php echo e(route('recharge.confirm')); ?>" method="POST" enctype="multipart/form-data">
      <?php echo csrf_field(); ?>
      <input type="hidden" name="method_id" value="<?php echo e($method->id); ?>">

      <input type="number" name="amount" class="form-control"
             min="<?php echo e($method->minimum); ?>" max="<?php echo e($method->maximum); ?>"
             placeholder="Amount in USDT" required>

      <input type="text" name="transaction_id" class="form-control"
             placeholder="Transaction Hash / ID" required>

      

      <button type="submit" class="btn-submit">Submit Deposit</button>
    </form>
  </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function () {

    const walletAddress = "<?php echo e($method->address); ?>";
    const qrBox = document.getElementById("qrcode");
    const size = qrBox.clientWidth - 30; // fits inside padding

    qrBox.innerHTML = "";

    new QRCode(qrBox, {
        text: walletAddress,
        width: size,
        height: size
    });

});

function copyAddress() {
    const copyText = document.getElementById("walletAddress");
    copyText.select();
    copyText.setSelectionRange(0, 99999);
    navigator.clipboard.writeText(copyText.value);
    alert("Copied: " + copyText.value);
}
</script>


</body>
</html>
<?php /**PATH C:\xampp\htdocs\Web165\resources\views/app/main/deposit/usdt.blade.php ENDPATH**/ ?>