<?php $__env->startSection('admin_content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4>Edit Package</h4>
                <form action="<?php echo e(route('admin.packages.toggleLock', $package->id)); ?>" method="POST" style="margin:0;">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-warning">
                        <?php if($package->is_locked): ?> Unlock Package <?php else: ?> Lock Package <?php endif; ?>
                    </button>
                </form>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('admin.packages.update', $package->id)); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Name</label>
                            <input type="text" name="name" class="form-control" value="<?php echo e(old('name', $package->name)); ?>" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Price</label>
                            <input type="number" step="0.01" name="price" class="form-control" value="<?php echo e(old('price', $package->price)); ?>" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Per Task Income</label>
                            <input type="number" step="0.01" name="per_task_income" class="form-control" value="<?php echo e(old('per_task_income', $package->per_task_income)); ?>" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Total Income</label>
                            <input type="number" step="0.01" name="total_income" class="form-control" value="<?php echo e(old('total_income', $package->total_income)); ?>" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Daily Task Limit</label>
                            <input type="number" name="daily_task_limit" class="form-control" value="<?php echo e(old('daily_task_limit', $package->daily_task_limit)); ?>" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Validity (Days)</label>
                            <input type="number" name="validity_days" class="form-control" value="<?php echo e(old('validity_days', $package->validity_days)); ?>" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Type</label>
                            <select name="type" class="form-control">
                                <option value="free" <?php if(old('type', $package->type)=='free'): ?> selected <?php endif; ?>>Free</option>
                                <option value="paid" <?php if(old('type', $package->type)=='paid'): ?> selected <?php endif; ?>>Paid</option>
                            </select>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Spins Count</label>
                            <input type="number" name="spins_count" class="form-control" value="<?php echo e(old('spins_count', $package->spins_count)); ?>">
                        </div>
                        <div class="form-group col-md-6">
                            <label>Package Logo</label>
                            <input type="file" name="logo" class="form-control-file">
                            <?php if($package->logo): ?>
                                <img src="<?php echo e($package->logo ? asset('storage/app/public/uploads/packages/' . basename($package->logo)) : asset('/default-logo.png')); ?>" alt="logo" width="50" class="mt-2">
                            <?php endif; ?>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Status</label>
                            <select name="status" class="form-control">
                                <option value="1" <?php if(old('status', $package->status)): ?> selected <?php endif; ?>>Active</option>
                                <option value="0" <?php if(!old('status', $package->status)): ?> selected <?php endif; ?>>Inactive</option>
                            </select>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary mt-3">Update Package</button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.partials.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Web165\resources\views/admin/packages/edit.blade.php ENDPATH**/ ?>