<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>History</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <div class="gtranslate_wrapper"></div>
<script>window.gtranslateSettings = {"default_language":"en","detect_browser_language":true,"languages":["en","sw", "ru","tr","hi","es","de","bg","fr","it","zh-TW"],
"wrapper_selector":".gtranslate_wrapper","horizontal_position":"right","vertical_position":"top"}</script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

<script src="https://cdn.gtranslate.net/widgets/latest/dropdown.js" defer></script>
<style>
  .gtranslate_wrapper {
    display: none !important;
  }
</style>
  <style>
    * {margin:0;padding:0;box-sizing:border-box;font-family:Arial,sans-serif;}
    body {
      min-height:100vh;
      background:url("<?php echo e(asset('ch/bg.png')); ?>") no-repeat center center/cover;
      padding:20px;color:#fff;
    }
    .container {max-width:1100px;margin:auto;}
    
    /* Back Button */
    .back-btn {
      display:inline-block;margin-bottom:20px;padding:8px 16px;
      background:rgba(0,0,0,0.3);backdrop-filter:blur(10px);
      border-radius:30px;color:#fff;text-decoration:none;font-weight:bold;
      border:1px solid rgba(255,255,255,0.3);box-shadow:0 3px 8px rgba(0,0,0,0.3);
      transition:0.3s;
    }
    .back-btn:hover {background:rgba(255,255,255,0.2);}
    
    h1 {text-align:center;margin-bottom:25px;font-size:28px;text-shadow:0 0 12px rgba(0,0,0,0.6);}
    
    /* Tabs */
    .tab-header {
      display:flex;justify-content:space-around;
      background:rgba(0,0,0,0.3);
      border-radius:10px;margin-bottom:20px;
      backdrop-filter:blur(8px);
    }
    .tab-header div {
      flex:1;text-align:center;padding:12px;cursor:pointer;
      font-weight:bold;color:#ddd;transition:0.3s;
    }
    .tab-header .active {color:#fff;border-bottom:3px solid #fff;}

    /* Records */
    .record-list {display:none;}
    .record {
      display:flex;justify-content:space-between;align-items:center;
      background:rgba(255,255,255,0.08);
      border-radius:12px;padding:12px 18px;margin-bottom:12px;
      box-shadow:0 3px 8px rgba(0,0,0,0.3);
      backdrop-filter:blur(10px);
    }
    .left {flex:1;}
    .left p {font-size:14px;margin-bottom:6px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;color:#fff;}
    /* Amounts -> cyan */
    .left span {font-size:18px;font-weight:bold;color:#00ffe0;}
    .right {text-align:right;}
    .right p {margin-bottom:6px;font-size:13px;color:#fff;}

    /* Status Colors */
    .status-pending {color:#facc15;font-weight:bold;}   /* Yellow */
    .status-paid {color:#4ade80;font-weight:bold;}      /* Green */
    .status-cancel {color:#f87171;font-weight:bold;}    /* Red */
  </style>
</head>
<body>
  <div class="container">
    
    <!-- Back Button -->
    <a href="<?php echo e(route('mine')); ?>" class="back-btn">← Back</a>

    <h1>Financial Records</h1>

    <!-- Tabs -->
    <div class="tab-header">
      <div class="tab-btn active" data-tab="recharge">Recharge record</div>
      <div class="tab-btn" data-tab="withdraw">Withdrawal record</div>
      <div class="tab-btn" data-tab="task">Task Revenue</div>
    </div>

    <!-- Recharge Records -->
    <div class="record-list recharge" style="display:block;">
      <?php $__empty_1 = true; $__currentLoopData = $recharges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <?php
          $charge = $deposit->charge_amount ?? 0;
          $finalAmount = $deposit->final_amount ?? ($deposit->amount - $charge);
          $displayId = implode('', array_map(fn() => rand(1,9), range(1,14)));
        ?>
        <div class="record">
          <div class="left">
            <p><?php echo e($displayId); ?></p>
            <span><?php echo e(number_format($finalAmount,2)); ?></span>
          </div>
          <div class="right">
            <p><?php echo e($deposit->created_at->format('Y-m-d H:i:s')); ?></p>
            <p class="<?php echo e(strtolower($deposit->status)=='success' ? 'status-paid' : 'status-pending'); ?>">
              <?php echo e(ucfirst($deposit->status)); ?>

            </p>
          </div>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <p>No recharge records found.</p>
      <?php endif; ?>
    </div>

    <!-- Withdraw Records -->
    <div class="record-list withdraw">
      <?php $__empty_1 = true; $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdraw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <?php
          $charge = $withdraw->charge ?? 0;
          $finalAmount = $withdraw->final_amount ?? ($withdraw->amount - $charge);
          $displayId = implode('', array_map(fn() => rand(1,9), range(1,14)));
        ?>
        <div class="record">
          <div class="left">
            <p><?php echo e($displayId); ?></p>
            <span><?php echo e(number_format($finalAmount,2)); ?></span>
          </div>
          <div class="right">
            <p><?php echo e($withdraw->created_at->format('Y-m-d H:i:s')); ?></p>
         <div class="right">

  
  <?php if($withdraw->status == 1 || strtolower($withdraw->status) == 'success'): ?>
    <p class="status-paid">Paid</p>
  <?php elseif($withdraw->status == 2 || strtolower($withdraw->status) == 'pending'): ?>
    <p class="status-pending">Bank Processing</p>
  <?php elseif($withdraw->status == 3 || strtolower($withdraw->status) == 'cancel' || strtolower($withdraw->status) == 'cancelled'): ?>
    <p class="status-cancel">Cancelled</p>
  <?php else: ?>
    <p class="status-pending">Processing Done</p> 
  <?php endif; ?>
</div>

          </div>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <p>No withdrawal records found.</p>
      <?php endif; ?>
    </div>

    <!-- Task Revenue Records -->
    <div class="record-list task">
      <?php $__empty_1 = true; $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <?php
          $displayId = implode('', array_map(fn() => rand(1,9), range(1,14)));
        ?>
        <div class="record">
          <div class="left">
            <p><?php echo e($displayId); ?></p>
            <span><?php echo e(number_format($task->earned,2)); ?></span>
          </div>
          <div class="right">
            <p><?php echo e($task->created_at->format('Y-m-d H:i:s')); ?></p>
            <p class="<?php echo e(strtolower($task->status)=='completed' ? 'status-paid' : 'status-pending'); ?>">
              <?php echo e(ucfirst($task->status)); ?>

            </p>
          </div>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <p>No task revenue found.</p>
      <?php endif; ?>
    </div>
  </div>

  <script>
    const tabBtns = document.querySelectorAll(".tab-btn");
    const lists = document.querySelectorAll(".record-list");
    tabBtns.forEach(btn=>{
      btn.addEventListener("click",()=>{
        tabBtns.forEach(b=>b.classList.remove("active"));
        btn.classList.add("active");
        lists.forEach(list=>list.style.display="none");
        document.querySelector("."+btn.dataset.tab).style.display="block";
      });
    });
  </script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\Web165\resources\views/app/main/history/history.blade.php ENDPATH**/ ?>